/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGitHubAccountTokenNamesResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListGitHubAccountTokenNamesResponse> {
    private final List<String> tokenNameList;
    private final String nextToken;

    private ListGitHubAccountTokenNamesResponse(BuilderImpl builder) {
        super(builder);
        this.tokenNameList = builder.tokenNameList;
        this.nextToken = builder.nextToken;
    }

    public List<String> tokenNameList() {
        return this.tokenNameList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenNameList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGitHubAccountTokenNamesResponse)) {
            return false;
        }
        ListGitHubAccountTokenNamesResponse other = (ListGitHubAccountTokenNamesResponse)((Object)obj);
        return Objects.equals(this.tokenNameList(), other.tokenNameList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGitHubAccountTokenNamesResponse").add("TokenNameList", this.tokenNameList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tokenNameList": {
                return Optional.of(clazz.cast(this.tokenNameList()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<String> tokenNameList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGitHubAccountTokenNamesResponse model) {
            this.tokenNameList(model.tokenNameList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getTokenNameList() {
            return this.tokenNameList;
        }

        @Override
        public final Builder tokenNameList(Collection<String> tokenNameList) {
            this.tokenNameList = GitHubAccountTokenNameListCopier.copy(tokenNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenNameList(String ... tokenNameList) {
            this.tokenNameList(Arrays.asList(tokenNameList));
            return this;
        }

        public final void setTokenNameList(Collection<String> tokenNameList) {
            this.tokenNameList = GitHubAccountTokenNameListCopier.copy(tokenNameList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGitHubAccountTokenNamesResponse build() {
            return new ListGitHubAccountTokenNamesResponse(this);
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    CopyableBuilder<Builder, ListGitHubAccountTokenNamesResponse> {
        public Builder tokenNameList(Collection<String> var1);

        public Builder tokenNameList(String ... var1);

        public Builder nextToken(String var1);
    }
}

