/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption;
import software.amazon.awssdk.services.codedeploy.model.DeploymentReadyOption;
import software.amazon.awssdk.services.codedeploy.model.GreenFleetProvisioningOption;
import software.amazon.awssdk.services.codedeploy.transform.BlueGreenDeploymentConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlueGreenDeploymentConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, BlueGreenDeploymentConfiguration> {
    private final BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess;
    private final DeploymentReadyOption deploymentReadyOption;
    private final GreenFleetProvisioningOption greenFleetProvisioningOption;

    private BlueGreenDeploymentConfiguration(BuilderImpl builder) {
        this.terminateBlueInstancesOnDeploymentSuccess = builder.terminateBlueInstancesOnDeploymentSuccess;
        this.deploymentReadyOption = builder.deploymentReadyOption;
        this.greenFleetProvisioningOption = builder.greenFleetProvisioningOption;
    }

    public BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess() {
        return this.terminateBlueInstancesOnDeploymentSuccess;
    }

    public DeploymentReadyOption deploymentReadyOption() {
        return this.deploymentReadyOption;
    }

    public GreenFleetProvisioningOption greenFleetProvisioningOption() {
        return this.greenFleetProvisioningOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateBlueInstancesOnDeploymentSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentReadyOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.greenFleetProvisioningOption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueGreenDeploymentConfiguration)) {
            return false;
        }
        BlueGreenDeploymentConfiguration other = (BlueGreenDeploymentConfiguration)obj;
        return Objects.equals(this.terminateBlueInstancesOnDeploymentSuccess(), other.terminateBlueInstancesOnDeploymentSuccess()) && Objects.equals(this.deploymentReadyOption(), other.deploymentReadyOption()) && Objects.equals(this.greenFleetProvisioningOption(), other.greenFleetProvisioningOption());
    }

    public String toString() {
        return ToString.builder((String)"BlueGreenDeploymentConfiguration").add("TerminateBlueInstancesOnDeploymentSuccess", (Object)this.terminateBlueInstancesOnDeploymentSuccess()).add("DeploymentReadyOption", (Object)this.deploymentReadyOption()).add("GreenFleetProvisioningOption", (Object)this.greenFleetProvisioningOption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "terminateBlueInstancesOnDeploymentSuccess": {
                return Optional.of(clazz.cast(this.terminateBlueInstancesOnDeploymentSuccess()));
            }
            case "deploymentReadyOption": {
                return Optional.of(clazz.cast(this.deploymentReadyOption()));
            }
            case "greenFleetProvisioningOption": {
                return Optional.of(clazz.cast(this.greenFleetProvisioningOption()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueGreenDeploymentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess;
        private DeploymentReadyOption deploymentReadyOption;
        private GreenFleetProvisioningOption greenFleetProvisioningOption;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueGreenDeploymentConfiguration model) {
            this.terminateBlueInstancesOnDeploymentSuccess(model.terminateBlueInstancesOnDeploymentSuccess);
            this.deploymentReadyOption(model.deploymentReadyOption);
            this.greenFleetProvisioningOption(model.greenFleetProvisioningOption);
        }

        public final BlueInstanceTerminationOption.Builder getTerminateBlueInstancesOnDeploymentSuccess() {
            return this.terminateBlueInstancesOnDeploymentSuccess != null ? this.terminateBlueInstancesOnDeploymentSuccess.toBuilder() : null;
        }

        @Override
        public final Builder terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption terminateBlueInstancesOnDeploymentSuccess) {
            this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
            return this;
        }

        public final void setTerminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption.BuilderImpl terminateBlueInstancesOnDeploymentSuccess) {
            this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess != null ? terminateBlueInstancesOnDeploymentSuccess.build() : null;
        }

        public final DeploymentReadyOption.Builder getDeploymentReadyOption() {
            return this.deploymentReadyOption != null ? this.deploymentReadyOption.toBuilder() : null;
        }

        @Override
        public final Builder deploymentReadyOption(DeploymentReadyOption deploymentReadyOption) {
            this.deploymentReadyOption = deploymentReadyOption;
            return this;
        }

        public final void setDeploymentReadyOption(DeploymentReadyOption.BuilderImpl deploymentReadyOption) {
            this.deploymentReadyOption = deploymentReadyOption != null ? deploymentReadyOption.build() : null;
        }

        public final GreenFleetProvisioningOption.Builder getGreenFleetProvisioningOption() {
            return this.greenFleetProvisioningOption != null ? this.greenFleetProvisioningOption.toBuilder() : null;
        }

        @Override
        public final Builder greenFleetProvisioningOption(GreenFleetProvisioningOption greenFleetProvisioningOption) {
            this.greenFleetProvisioningOption = greenFleetProvisioningOption;
            return this;
        }

        public final void setGreenFleetProvisioningOption(GreenFleetProvisioningOption.BuilderImpl greenFleetProvisioningOption) {
            this.greenFleetProvisioningOption = greenFleetProvisioningOption != null ? greenFleetProvisioningOption.build() : null;
        }

        public BlueGreenDeploymentConfiguration build() {
            return new BlueGreenDeploymentConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlueGreenDeploymentConfiguration> {
        public Builder terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOption var1);

        default public Builder terminateBlueInstancesOnDeploymentSuccess(Consumer<BlueInstanceTerminationOption.Builder> terminateBlueInstancesOnDeploymentSuccess) {
            return this.terminateBlueInstancesOnDeploymentSuccess((BlueInstanceTerminationOption)((BlueInstanceTerminationOption.Builder)BlueInstanceTerminationOption.builder().apply(terminateBlueInstancesOnDeploymentSuccess)).build());
        }

        public Builder deploymentReadyOption(DeploymentReadyOption var1);

        default public Builder deploymentReadyOption(Consumer<DeploymentReadyOption.Builder> deploymentReadyOption) {
            return this.deploymentReadyOption((DeploymentReadyOption)((DeploymentReadyOption.Builder)DeploymentReadyOption.builder().apply(deploymentReadyOption)).build());
        }

        public Builder greenFleetProvisioningOption(GreenFleetProvisioningOption var1);

        default public Builder greenFleetProvisioningOption(Consumer<GreenFleetProvisioningOption.Builder> greenFleetProvisioningOption) {
            return this.greenFleetProvisioningOption((GreenFleetProvisioningOption)((GreenFleetProvisioningOption.Builder)GreenFleetProvisioningOption.builder().apply(greenFleetProvisioningOption)).build());
        }
    }
}

