/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo;

@SdkInternalApi
public class GenericRevisionInfoMarshaller {
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> DEPLOYMENTGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentGroups").build();
    private static final MarshallingInfo<Instant> FIRSTUSEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstUsedTime").build();
    private static final MarshallingInfo<Instant> LASTUSEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUsedTime").build();
    private static final MarshallingInfo<Instant> REGISTERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registerTime").build();
    private static final GenericRevisionInfoMarshaller INSTANCE = new GenericRevisionInfoMarshaller();

    public static GenericRevisionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GenericRevisionInfo genericRevisionInfo, ProtocolMarshaller protocolMarshaller) {
        if (genericRevisionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)genericRevisionInfo.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(genericRevisionInfo.deploymentGroups(), DEPLOYMENTGROUPS_BINDING);
            protocolMarshaller.marshall((Object)genericRevisionInfo.firstUsedTime(), FIRSTUSEDTIME_BINDING);
            protocolMarshaller.marshall((Object)genericRevisionInfo.lastUsedTime(), LASTUSEDTIME_BINDING);
            protocolMarshaller.marshall((Object)genericRevisionInfo.registerTime(), REGISTERTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

