/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.Diagnostics;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus;
import software.amazon.awssdk.services.codedeploy.transform.LifecycleEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleEvent
implements StructuredPojo,
ToCopyableBuilder<Builder, LifecycleEvent> {
    private final String lifecycleEventName;
    private final Diagnostics diagnostics;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;

    private LifecycleEvent(BuilderImpl builder) {
        this.lifecycleEventName = builder.lifecycleEventName;
        this.diagnostics = builder.diagnostics;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
    }

    public String lifecycleEventName() {
        return this.lifecycleEventName;
    }

    public Diagnostics diagnostics() {
        return this.diagnostics;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public LifecycleEventStatus status() {
        return LifecycleEventStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diagnostics());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleEvent)) {
            return false;
        }
        LifecycleEvent other = (LifecycleEvent)obj;
        return Objects.equals(this.lifecycleEventName(), other.lifecycleEventName()) && Objects.equals(this.diagnostics(), other.diagnostics()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lifecycleEventName() != null) {
            sb.append("LifecycleEventName: ").append(this.lifecycleEventName()).append(",");
        }
        if (this.diagnostics() != null) {
            sb.append("Diagnostics: ").append(this.diagnostics()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecycleEventName": {
                return Optional.of(clazz.cast(this.lifecycleEventName()));
            }
            case "diagnostics": {
                return Optional.of(clazz.cast(this.diagnostics()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LifecycleEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleEventName;
        private Diagnostics diagnostics;
        private Instant startTime;
        private Instant endTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleEvent model) {
            this.lifecycleEventName(model.lifecycleEventName);
            this.diagnostics(model.diagnostics);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
        }

        public final String getLifecycleEventName() {
            return this.lifecycleEventName;
        }

        @Override
        public final Builder lifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
            return this;
        }

        public final void setLifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
        }

        public final Diagnostics.Builder getDiagnostics() {
            return this.diagnostics != null ? this.diagnostics.toBuilder() : null;
        }

        @Override
        public final Builder diagnostics(Diagnostics diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public final void setDiagnostics(Diagnostics.BuilderImpl diagnostics) {
            this.diagnostics = diagnostics != null ? diagnostics.build() : null;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecycleEventStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public LifecycleEvent build() {
            return new LifecycleEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleEvent> {
        public Builder lifecycleEventName(String var1);

        public Builder diagnostics(Diagnostics var1);

        default public Builder diagnostics(Consumer<Diagnostics.Builder> diagnostics) {
            return this.diagnostics((Diagnostics)((Diagnostics.Builder)Diagnostics.builder().apply(diagnostics)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(LifecycleEventStatus var1);
    }
}

