/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.transform.LastDeploymentInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LastDeploymentInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, LastDeploymentInfo> {
    private final String deploymentId;
    private final String status;
    private final Instant endTime;
    private final Instant createTime;

    private LastDeploymentInfo(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.createTime = builder.createTime;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastDeploymentInfo)) {
            return false;
        }
        LastDeploymentInfo other = (LastDeploymentInfo)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.createTime(), other.createTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "createTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LastDeploymentInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String status;
        private Instant endTime;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LastDeploymentInfo model) {
            this.deploymentId(model.deploymentId);
            this.status(model.status);
            this.endTime(model.endTime);
            this.createTime(model.createTime);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public LastDeploymentInfo build() {
            return new LastDeploymentInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LastDeploymentInfo> {
        public Builder deploymentId(String var1);

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder endTime(Instant var1);

        public Builder createTime(Instant var1);
    }
}

