/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.Alarm;
import software.amazon.awssdk.services.codedeploy.model.AlarmListCopier;
import software.amazon.awssdk.services.codedeploy.transform.AlarmConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AlarmConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, AlarmConfiguration> {
    private final Boolean enabled;
    private final Boolean ignorePollAlarmFailure;
    private final List<Alarm> alarms;

    private AlarmConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.ignorePollAlarmFailure = builder.ignorePollAlarmFailure;
        this.alarms = builder.alarms;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean ignorePollAlarmFailure() {
        return this.ignorePollAlarmFailure;
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignorePollAlarmFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmConfiguration)) {
            return false;
        }
        AlarmConfiguration other = (AlarmConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.ignorePollAlarmFailure(), other.ignorePollAlarmFailure()) && Objects.equals(this.alarms(), other.alarms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.ignorePollAlarmFailure() != null) {
            sb.append("IgnorePollAlarmFailure: ").append(this.ignorePollAlarmFailure()).append(",");
        }
        if (this.alarms() != null) {
            sb.append("Alarms: ").append(this.alarms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "ignorePollAlarmFailure": {
                return Optional.of(clazz.cast(this.ignorePollAlarmFailure()));
            }
            case "alarms": {
                return Optional.of(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlarmConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean ignorePollAlarmFailure;
        private List<Alarm> alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmConfiguration model) {
            this.enabled(model.enabled);
            this.ignorePollAlarmFailure(model.ignorePollAlarmFailure);
            this.alarms(model.alarms);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getIgnorePollAlarmFailure() {
            return this.ignorePollAlarmFailure;
        }

        @Override
        public final Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
            return this;
        }

        public final void setIgnorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
            this.ignorePollAlarmFailure = ignorePollAlarmFailure;
        }

        public final Collection<Alarm.Builder> getAlarms() {
            return this.alarms != null ? (Collection)this.alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmListCopier.copyFromBuilder(alarms);
        }

        public AlarmConfiguration build() {
            return new AlarmConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AlarmConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder ignorePollAlarmFailure(Boolean var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);
    }
}

