/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;

@SdkInternalApi
public class TagFilterMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final TagFilterMarshaller INSTANCE = new TagFilterMarshaller();

    public static TagFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TagFilter tagFilter, ProtocolMarshaller protocolMarshaller) {
        if (tagFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tagFilter.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)tagFilter.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)tagFilter.typeString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

