/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDeploymentInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetDeploymentInstanceRequest> {
    private final String deploymentId;
    private final String instanceId;

    private GetDeploymentInstanceRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentInstanceRequest)) {
            return false;
        }
        GetDeploymentInstanceRequest other = (GetDeploymentInstanceRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "instanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentInstanceRequest model) {
            this.deploymentId(model.deploymentId);
            this.instanceId(model.instanceId);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public GetDeploymentInstanceRequest build() {
            return new GetDeploymentInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDeploymentInstanceRequest> {
        public Builder deploymentId(String var1);

        public Builder instanceId(String var1);
    }
}

