/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetApplicationRevisionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetApplicationRevisionResponse> {
    private final String applicationName;
    private final RevisionLocation revision;
    private final GenericRevisionInfo revisionInfo;

    private GetApplicationRevisionResponse(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.revision = builder.revision;
        this.revisionInfo = builder.revisionInfo;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    public GenericRevisionInfo revisionInfo() {
        return this.revisionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRevisionResponse)) {
            return false;
        }
        GetApplicationRevisionResponse other = (GetApplicationRevisionResponse)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.revisionInfo(), other.revisionInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (this.revisionInfo() != null) {
            sb.append("RevisionInfo: ").append(this.revisionInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "revision": {
                return Optional.of(clazz.cast(this.revision()));
            }
            case "revisionInfo": {
                return Optional.of(clazz.cast(this.revisionInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private RevisionLocation revision;
        private GenericRevisionInfo revisionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRevisionResponse model) {
            this.applicationName(model.applicationName);
            this.revision(model.revision);
            this.revisionInfo(model.revisionInfo);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        public final GenericRevisionInfo.Builder getRevisionInfo() {
            return this.revisionInfo != null ? this.revisionInfo.toBuilder() : null;
        }

        @Override
        public final Builder revisionInfo(GenericRevisionInfo revisionInfo) {
            this.revisionInfo = revisionInfo;
            return this;
        }

        public final void setRevisionInfo(GenericRevisionInfo.BuilderImpl revisionInfo) {
            this.revisionInfo = revisionInfo != null ? revisionInfo.build() : null;
        }

        public GetApplicationRevisionResponse build() {
            return new GetApplicationRevisionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetApplicationRevisionResponse> {
        public Builder applicationName(String var1);

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().apply(revision)).build());
        }

        public Builder revisionInfo(GenericRevisionInfo var1);

        default public Builder revisionInfo(Consumer<GenericRevisionInfo.Builder> revisionInfo) {
            return this.revisionInfo((GenericRevisionInfo)((GenericRevisionInfo.Builder)GenericRevisionInfo.builder().apply(revisionInfo)).build());
        }
    }
}

