/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetDeploymentsRequest> {
    private final List<String> deploymentIds;

    private BatchGetDeploymentsRequest(BuilderImpl builder) {
        this.deploymentIds = builder.deploymentIds;
    }

    public List<String> deploymentIds() {
        return this.deploymentIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsRequest)) {
            return false;
        }
        BatchGetDeploymentsRequest other = (BatchGetDeploymentsRequest)((Object)obj);
        return Objects.equals(this.deploymentIds(), other.deploymentIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentIds() != null) {
            sb.append("DeploymentIds: ").append(this.deploymentIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentIds": {
                return Optional.of(clazz.cast(this.deploymentIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> deploymentIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsRequest model) {
            this.deploymentIds(model.deploymentIds);
        }

        public final Collection<String> getDeploymentIds() {
            return this.deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String ... deploymentIds) {
            this.deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
        }

        public BatchGetDeploymentsRequest build() {
            return new BatchGetDeploymentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetDeploymentsRequest> {
        public Builder deploymentIds(Collection<String> var1);

        public Builder deploymentIds(String ... var1);
    }
}

