/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentInfo;

@SdkInternalApi
public class DeploymentInfoMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationName").build();
    private static final MarshallingInfo<String> DEPLOYMENTGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentGroupName").build();
    private static final MarshallingInfo<String> DEPLOYMENTCONFIGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentConfigName").build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").build();
    private static final MarshallingInfo<StructuredPojo> PREVIOUSREVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("previousRevision").build();
    private static final MarshallingInfo<StructuredPojo> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<StructuredPojo> ERRORINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorInformation").build();
    private static final MarshallingInfo<Instant> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").build();
    private static final MarshallingInfo<Instant> COMPLETETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completeTime").build();
    private static final MarshallingInfo<StructuredPojo> DEPLOYMENTOVERVIEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentOverview").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> CREATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creator").build();
    private static final MarshallingInfo<Boolean> IGNOREAPPLICATIONSTOPFAILURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ignoreApplicationStopFailures").build();
    private static final MarshallingInfo<StructuredPojo> AUTOROLLBACKCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoRollbackConfiguration").build();
    private static final MarshallingInfo<Boolean> UPDATEOUTDATEDINSTANCESONLY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updateOutdatedInstancesOnly").build();
    private static final MarshallingInfo<StructuredPojo> ROLLBACKINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rollbackInfo").build();
    private static final MarshallingInfo<StructuredPojo> DEPLOYMENTSTYLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentStyle").build();
    private static final MarshallingInfo<StructuredPojo> TARGETINSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetInstances").build();
    private static final MarshallingInfo<Boolean> INSTANCETERMINATIONWAITTIMESTARTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceTerminationWaitTimeStarted").build();
    private static final MarshallingInfo<StructuredPojo> BLUEGREENDEPLOYMENTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueGreenDeploymentConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> LOADBALANCERINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loadBalancerInfo").build();
    private static final MarshallingInfo<String> ADDITIONALDEPLOYMENTSTATUSINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalDeploymentStatusInfo").build();
    private static final MarshallingInfo<String> FILEEXISTSBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileExistsBehavior").build();
    private static final DeploymentInfoMarshaller INSTANCE = new DeploymentInfoMarshaller();

    public static DeploymentInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeploymentInfo deploymentInfo, ProtocolMarshaller protocolMarshaller) {
        if (deploymentInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deploymentInfo.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.deploymentGroupName(), DEPLOYMENTGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.deploymentConfigName(), DEPLOYMENTCONFIGNAME_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.previousRevision(), PREVIOUSREVISION_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.revision(), REVISION_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.errorInformation(), ERRORINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.createTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.completeTime(), COMPLETETIME_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.deploymentOverview(), DEPLOYMENTOVERVIEW_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.creatorString(), CREATOR_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.ignoreApplicationStopFailures(), IGNOREAPPLICATIONSTOPFAILURES_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.autoRollbackConfiguration(), AUTOROLLBACKCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.updateOutdatedInstancesOnly(), UPDATEOUTDATEDINSTANCESONLY_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.rollbackInfo(), ROLLBACKINFO_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.deploymentStyle(), DEPLOYMENTSTYLE_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.targetInstances(), TARGETINSTANCES_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.instanceTerminationWaitTimeStarted(), INSTANCETERMINATIONWAITTIMESTARTED_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.blueGreenDeploymentConfiguration(), BLUEGREENDEPLOYMENTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.loadBalancerInfo(), LOADBALANCERINFO_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.additionalDeploymentStatusInfo(), ADDITIONALDEPLOYMENTSTATUSINFO_BINDING);
            protocolMarshaller.marshall((Object)deploymentInfo.fileExistsBehaviorString(), FILEEXISTSBEHAVIOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

