/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupNameListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.transform.TargetInstancesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetInstances
implements StructuredPojo,
ToCopyableBuilder<Builder, TargetInstances> {
    private final List<EC2TagFilter> tagFilters;
    private final List<String> autoScalingGroups;

    private TargetInstances(BuilderImpl builder) {
        this.tagFilters = builder.tagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
    }

    public List<EC2TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public List<String> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tagFilters() == null ? 0 : this.tagFilters().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingGroups() == null ? 0 : this.autoScalingGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstances)) {
            return false;
        }
        TargetInstances other = (TargetInstances)obj;
        if (other.tagFilters() == null ^ this.tagFilters() == null) {
            return false;
        }
        if (other.tagFilters() != null && !other.tagFilters().equals(this.tagFilters())) {
            return false;
        }
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        return other.autoScalingGroups() == null || other.autoScalingGroups().equals(this.autoScalingGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tagFilters() != null) {
            sb.append("TagFilters: ").append(this.tagFilters()).append(",");
        }
        if (this.autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.autoScalingGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tagFilters": {
                return Optional.of(clazz.cast(this.tagFilters()));
            }
            case "autoScalingGroups": {
                return Optional.of(clazz.cast(this.autoScalingGroups()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetInstancesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EC2TagFilter> tagFilters;
        private List<String> autoScalingGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstances model) {
            this.tagFilters(model.tagFilters);
            this.autoScalingGroups(model.autoScalingGroups);
        }

        public final Collection<EC2TagFilter.Builder> getTagFilters() {
            return this.tagFilters != null ? (Collection)this.tagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagFilters(Collection<EC2TagFilter> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(EC2TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        public final void setTagFilters(Collection<EC2TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        public final Collection<String> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        public TargetInstances build() {
            return new TargetInstances(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetInstances> {
        public Builder tagFilters(Collection<EC2TagFilter> var1);

        public Builder tagFilters(EC2TagFilter ... var1);

        public Builder autoScalingGroups(Collection<String> var1);

        public Builder autoScalingGroups(String ... var1);
    }
}

