/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentConfigsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDeploymentConfigsResponse> {
    private final List<String> deploymentConfigsList;
    private final String nextToken;

    private ListDeploymentConfigsResponse(BuilderImpl builder) {
        this.deploymentConfigsList = builder.deploymentConfigsList;
        this.nextToken = builder.nextToken;
    }

    public List<String> deploymentConfigsList() {
        return this.deploymentConfigsList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentConfigsList() == null ? 0 : this.deploymentConfigsList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentConfigsResponse)) {
            return false;
        }
        ListDeploymentConfigsResponse other = (ListDeploymentConfigsResponse)((Object)obj);
        if (other.deploymentConfigsList() == null ^ this.deploymentConfigsList() == null) {
            return false;
        }
        if (other.deploymentConfigsList() != null && !other.deploymentConfigsList().equals(this.deploymentConfigsList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentConfigsList() != null) {
            sb.append("DeploymentConfigsList: ").append(this.deploymentConfigsList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigsList": {
                return Optional.of(clazz.cast(this.deploymentConfigsList()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> deploymentConfigsList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentConfigsResponse model) {
            this.deploymentConfigsList(model.deploymentConfigsList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDeploymentConfigsList() {
            return this.deploymentConfigsList;
        }

        @Override
        public final Builder deploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentConfigsList(String ... deploymentConfigsList) {
            this.deploymentConfigsList(Arrays.asList(deploymentConfigsList));
            return this;
        }

        public final void setDeploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDeploymentConfigsResponse build() {
            return new ListDeploymentConfigsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeploymentConfigsResponse> {
        public Builder deploymentConfigsList(Collection<String> var1);

        public Builder deploymentConfigsList(String ... var1);

        public Builder nextToken(String var1);
    }
}

