/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApplicationRevisionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListApplicationRevisionsResponse> {
    private final List<RevisionLocation> revisions;
    private final String nextToken;

    private ListApplicationRevisionsResponse(BuilderImpl builder) {
        this.revisions = builder.revisions;
        this.nextToken = builder.nextToken;
    }

    public List<RevisionLocation> revisions() {
        return this.revisions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.revisions() == null ? 0 : this.revisions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsResponse)) {
            return false;
        }
        ListApplicationRevisionsResponse other = (ListApplicationRevisionsResponse)((Object)obj);
        if (other.revisions() == null ^ this.revisions() == null) {
            return false;
        }
        if (other.revisions() != null && !other.revisions().equals(this.revisions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.revisions() != null) {
            sb.append("Revisions: ").append(this.revisions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisions": {
                return Optional.of(clazz.cast(this.revisions()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<RevisionLocation> revisions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsResponse model) {
            this.revisions(model.revisions);
            this.nextToken(model.nextToken);
        }

        public final Collection<RevisionLocation.Builder> getRevisions() {
            return this.revisions != null ? (Collection)this.revisions.stream().map(RevisionLocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionLocation ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        public final void setRevisions(Collection<RevisionLocation.BuilderImpl> revisions) {
            this.revisions = RevisionLocationListCopier.copyFromBuilder(revisions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListApplicationRevisionsResponse build() {
            return new ListApplicationRevisionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListApplicationRevisionsResponse> {
        public Builder revisions(Collection<RevisionLocation> var1);

        public Builder revisions(RevisionLocation ... var1);

        public Builder nextToken(String var1);
    }
}

