/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.services.codedeploy.transform.GenericRevisionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenericRevisionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, GenericRevisionInfo> {
    private final String description;
    private final List<String> deploymentGroups;
    private final Instant firstUsedTime;
    private final Instant lastUsedTime;
    private final Instant registerTime;

    private GenericRevisionInfo(BuilderImpl builder) {
        this.description = builder.description;
        this.deploymentGroups = builder.deploymentGroups;
        this.firstUsedTime = builder.firstUsedTime;
        this.lastUsedTime = builder.lastUsedTime;
        this.registerTime = builder.registerTime;
    }

    public String description() {
        return this.description;
    }

    public List<String> deploymentGroups() {
        return this.deploymentGroups;
    }

    public Instant firstUsedTime() {
        return this.firstUsedTime;
    }

    public Instant lastUsedTime() {
        return this.lastUsedTime;
    }

    public Instant registerTime() {
        return this.registerTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroups() == null ? 0 : this.deploymentGroups().hashCode());
        hashCode = 31 * hashCode + (this.firstUsedTime() == null ? 0 : this.firstUsedTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUsedTime() == null ? 0 : this.lastUsedTime().hashCode());
        hashCode = 31 * hashCode + (this.registerTime() == null ? 0 : this.registerTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericRevisionInfo)) {
            return false;
        }
        GenericRevisionInfo other = (GenericRevisionInfo)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deploymentGroups() == null ^ this.deploymentGroups() == null) {
            return false;
        }
        if (other.deploymentGroups() != null && !other.deploymentGroups().equals(this.deploymentGroups())) {
            return false;
        }
        if (other.firstUsedTime() == null ^ this.firstUsedTime() == null) {
            return false;
        }
        if (other.firstUsedTime() != null && !other.firstUsedTime().equals(this.firstUsedTime())) {
            return false;
        }
        if (other.lastUsedTime() == null ^ this.lastUsedTime() == null) {
            return false;
        }
        if (other.lastUsedTime() != null && !other.lastUsedTime().equals(this.lastUsedTime())) {
            return false;
        }
        if (other.registerTime() == null ^ this.registerTime() == null) {
            return false;
        }
        return other.registerTime() == null || other.registerTime().equals(this.registerTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.deploymentGroups() != null) {
            sb.append("DeploymentGroups: ").append(this.deploymentGroups()).append(",");
        }
        if (this.firstUsedTime() != null) {
            sb.append("FirstUsedTime: ").append(this.firstUsedTime()).append(",");
        }
        if (this.lastUsedTime() != null) {
            sb.append("LastUsedTime: ").append(this.lastUsedTime()).append(",");
        }
        if (this.registerTime() != null) {
            sb.append("RegisterTime: ").append(this.registerTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "deploymentGroups": {
                return Optional.of(clazz.cast(this.deploymentGroups()));
            }
            case "firstUsedTime": {
                return Optional.of(clazz.cast(this.firstUsedTime()));
            }
            case "lastUsedTime": {
                return Optional.of(clazz.cast(this.lastUsedTime()));
            }
            case "registerTime": {
                return Optional.of(clazz.cast(this.registerTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GenericRevisionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> deploymentGroups;
        private Instant firstUsedTime;
        private Instant lastUsedTime;
        private Instant registerTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenericRevisionInfo model) {
            this.description(model.description);
            this.deploymentGroups(model.deploymentGroups);
            this.firstUsedTime(model.firstUsedTime);
            this.lastUsedTime(model.lastUsedTime);
            this.registerTime(model.registerTime);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getDeploymentGroups() {
            return this.deploymentGroups;
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String ... deploymentGroups) {
            this.deploymentGroups(Arrays.asList(deploymentGroups));
            return this;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        public final Instant getFirstUsedTime() {
            return this.firstUsedTime;
        }

        @Override
        public final Builder firstUsedTime(Instant firstUsedTime) {
            this.firstUsedTime = firstUsedTime;
            return this;
        }

        public final void setFirstUsedTime(Instant firstUsedTime) {
            this.firstUsedTime = firstUsedTime;
        }

        public final Instant getLastUsedTime() {
            return this.lastUsedTime;
        }

        @Override
        public final Builder lastUsedTime(Instant lastUsedTime) {
            this.lastUsedTime = lastUsedTime;
            return this;
        }

        public final void setLastUsedTime(Instant lastUsedTime) {
            this.lastUsedTime = lastUsedTime;
        }

        public final Instant getRegisterTime() {
            return this.registerTime;
        }

        @Override
        public final Builder registerTime(Instant registerTime) {
            this.registerTime = registerTime;
            return this;
        }

        public final void setRegisterTime(Instant registerTime) {
            this.registerTime = registerTime;
        }

        public GenericRevisionInfo build() {
            return new GenericRevisionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenericRevisionInfo> {
        public Builder description(String var1);

        public Builder deploymentGroups(Collection<String> var1);

        public Builder deploymentGroups(String ... var1);

        public Builder firstUsedTime(Instant var1);

        public Builder lastUsedTime(Instant var1);

        public Builder registerTime(Instant var1);
    }
}

