/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOption;
import software.amazon.awssdk.services.codedeploy.model.DeploymentType;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentStyleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentStyle
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentStyle> {
    private final String deploymentType;
    private final String deploymentOption;

    private DeploymentStyle(BuilderImpl builder) {
        this.deploymentType = builder.deploymentType;
        this.deploymentOption = builder.deploymentOption;
    }

    public DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public String deploymentTypeString() {
        return this.deploymentType;
    }

    public DeploymentOption deploymentOption() {
        return DeploymentOption.fromValue(this.deploymentOption);
    }

    public String deploymentOptionString() {
        return this.deploymentOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentTypeString() == null ? 0 : this.deploymentTypeString().hashCode());
        hashCode = 31 * hashCode + (this.deploymentOptionString() == null ? 0 : this.deploymentOptionString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStyle)) {
            return false;
        }
        DeploymentStyle other = (DeploymentStyle)obj;
        if (other.deploymentTypeString() == null ^ this.deploymentTypeString() == null) {
            return false;
        }
        if (other.deploymentTypeString() != null && !other.deploymentTypeString().equals(this.deploymentTypeString())) {
            return false;
        }
        if (other.deploymentOptionString() == null ^ this.deploymentOptionString() == null) {
            return false;
        }
        return other.deploymentOptionString() == null || other.deploymentOptionString().equals(this.deploymentOptionString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentTypeString() != null) {
            sb.append("DeploymentType: ").append(this.deploymentTypeString()).append(",");
        }
        if (this.deploymentOptionString() != null) {
            sb.append("DeploymentOption: ").append(this.deploymentOptionString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentType": {
                return Optional.of(clazz.cast(this.deploymentTypeString()));
            }
            case "deploymentOption": {
                return Optional.of(clazz.cast(this.deploymentOptionString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentStyleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentType;
        private String deploymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStyle model) {
            this.deploymentType(model.deploymentType);
            this.deploymentOption(model.deploymentOption);
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getDeploymentOption() {
            return this.deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        @Override
        public final Builder deploymentOption(DeploymentOption deploymentOption) {
            this.deploymentOption(deploymentOption.toString());
            return this;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        public DeploymentStyle build() {
            return new DeploymentStyle(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentStyle> {
        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder deploymentOption(String var1);

        public Builder deploymentOption(DeploymentOption var1);
    }
}

