/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupNameListCopier;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;
import software.amazon.awssdk.services.codedeploy.model.TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfig;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeploymentGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDeploymentGroupRequest> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final String deploymentConfigName;
    private final List<EC2TagFilter> ec2TagFilters;
    private final List<TagFilter> onPremisesInstanceTagFilters;
    private final List<String> autoScalingGroups;
    private final String serviceRoleArn;
    private final List<TriggerConfig> triggerConfigurations;
    private final AlarmConfiguration alarmConfiguration;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final DeploymentStyle deploymentStyle;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;

    private CreateDeploymentGroupRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public List<EC2TagFilter> ec2TagFilters() {
        return this.ec2TagFilters;
    }

    public List<TagFilter> onPremisesInstanceTagFilters() {
        return this.onPremisesInstanceTagFilters;
    }

    public List<String> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public List<TriggerConfig> triggerConfigurations() {
        return this.triggerConfigurations;
    }

    public AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroupName() == null ? 0 : this.deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentConfigName() == null ? 0 : this.deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.ec2TagFilters() == null ? 0 : this.ec2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.onPremisesInstanceTagFilters() == null ? 0 : this.onPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingGroups() == null ? 0 : this.autoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.triggerConfigurations() == null ? 0 : this.triggerConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.alarmConfiguration() == null ? 0 : this.alarmConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.autoRollbackConfiguration() == null ? 0 : this.autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.deploymentStyle() == null ? 0 : this.deploymentStyle().hashCode());
        hashCode = 31 * hashCode + (this.blueGreenDeploymentConfiguration() == null ? 0 : this.blueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerInfo() == null ? 0 : this.loadBalancerInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentGroupRequest)) {
            return false;
        }
        CreateDeploymentGroupRequest other = (CreateDeploymentGroupRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.ec2TagFilters() == null ^ this.ec2TagFilters() == null) {
            return false;
        }
        if (other.ec2TagFilters() != null && !other.ec2TagFilters().equals(this.ec2TagFilters())) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() == null ^ this.onPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() != null && !other.onPremisesInstanceTagFilters().equals(this.onPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        if (other.autoScalingGroups() != null && !other.autoScalingGroups().equals(this.autoScalingGroups())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.triggerConfigurations() == null ^ this.triggerConfigurations() == null) {
            return false;
        }
        if (other.triggerConfigurations() != null && !other.triggerConfigurations().equals(this.triggerConfigurations())) {
            return false;
        }
        if (other.alarmConfiguration() == null ^ this.alarmConfiguration() == null) {
            return false;
        }
        if (other.alarmConfiguration() != null && !other.alarmConfiguration().equals(this.alarmConfiguration())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.deploymentStyle() == null ^ this.deploymentStyle() == null) {
            return false;
        }
        if (other.deploymentStyle() != null && !other.deploymentStyle().equals(this.deploymentStyle())) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() == null ^ this.blueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() != null && !other.blueGreenDeploymentConfiguration().equals(this.blueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.loadBalancerInfo() == null ^ this.loadBalancerInfo() == null) {
            return false;
        }
        return other.loadBalancerInfo() == null || other.loadBalancerInfo().equals(this.loadBalancerInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.deploymentGroupName()).append(",");
        }
        if (this.deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.deploymentConfigName()).append(",");
        }
        if (this.ec2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(this.ec2TagFilters()).append(",");
        }
        if (this.onPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(this.onPremisesInstanceTagFilters()).append(",");
        }
        if (this.autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.autoScalingGroups()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.triggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(this.triggerConfigurations()).append(",");
        }
        if (this.alarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(this.alarmConfiguration()).append(",");
        }
        if (this.autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.autoRollbackConfiguration()).append(",");
        }
        if (this.deploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(this.deploymentStyle()).append(",");
        }
        if (this.blueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(this.blueGreenDeploymentConfiguration()).append(",");
        }
        if (this.loadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(this.loadBalancerInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.of(clazz.cast(this.deploymentGroupName()));
            }
            case "deploymentConfigName": {
                return Optional.of(clazz.cast(this.deploymentConfigName()));
            }
            case "ec2TagFilters": {
                return Optional.of(clazz.cast(this.ec2TagFilters()));
            }
            case "onPremisesInstanceTagFilters": {
                return Optional.of(clazz.cast(this.onPremisesInstanceTagFilters()));
            }
            case "autoScalingGroups": {
                return Optional.of(clazz.cast(this.autoScalingGroups()));
            }
            case "serviceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "triggerConfigurations": {
                return Optional.of(clazz.cast(this.triggerConfigurations()));
            }
            case "alarmConfiguration": {
                return Optional.of(clazz.cast(this.alarmConfiguration()));
            }
            case "autoRollbackConfiguration": {
                return Optional.of(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "deploymentStyle": {
                return Optional.of(clazz.cast(this.deploymentStyle()));
            }
            case "blueGreenDeploymentConfiguration": {
                return Optional.of(clazz.cast(this.blueGreenDeploymentConfiguration()));
            }
            case "loadBalancerInfo": {
                return Optional.of(clazz.cast(this.loadBalancerInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private String deploymentConfigName;
        private List<EC2TagFilter> ec2TagFilters;
        private List<TagFilter> onPremisesInstanceTagFilters;
        private List<String> autoScalingGroups;
        private String serviceRoleArn;
        private List<TriggerConfig> triggerConfigurations;
        private AlarmConfiguration alarmConfiguration;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private DeploymentStyle deploymentStyle;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentGroupRequest model) {
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.deploymentConfigName(model.deploymentConfigName);
            this.ec2TagFilters(model.ec2TagFilters);
            this.onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            this.autoScalingGroups(model.autoScalingGroups);
            this.serviceRoleArn(model.serviceRoleArn);
            this.triggerConfigurations(model.triggerConfigurations);
            this.alarmConfiguration(model.alarmConfiguration);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.deploymentStyle(model.deploymentStyle);
            this.blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.loadBalancerInfo(model.loadBalancerInfo);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter.Builder> getEc2TagFilters() {
            return this.ec2TagFilters != null ? (Collection)this.ec2TagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter ... ec2TagFilters) {
            this.ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        public final Collection<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            return this.onPremisesInstanceTagFilters != null ? (Collection)this.onPremisesInstanceTagFilters.stream().map(TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        public final Collection<String> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Collection<TriggerConfig.Builder> getTriggerConfigurations() {
            return this.triggerConfigurations != null ? (Collection)this.triggerConfigurations.stream().map(TriggerConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig ... triggerConfigurations) {
            this.triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return this.deploymentStyle != null ? this.deploymentStyle.toBuilder() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration != null ? this.blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.build() : null;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return this.loadBalancerInfo != null ? this.loadBalancerInfo.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        public CreateDeploymentGroupRequest build() {
            return new CreateDeploymentGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDeploymentGroupRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder ec2TagFilters(Collection<EC2TagFilter> var1);

        public Builder ec2TagFilters(EC2TagFilter ... var1);

        public Builder onPremisesInstanceTagFilters(Collection<TagFilter> var1);

        public Builder onPremisesInstanceTagFilters(TagFilter ... var1);

        public Builder autoScalingGroups(Collection<String> var1);

        public Builder autoScalingGroups(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder triggerConfigurations(Collection<TriggerConfig> var1);

        public Builder triggerConfigurations(TriggerConfig ... var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        public Builder deploymentStyle(DeploymentStyle var1);

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        public Builder loadBalancerInfo(LoadBalancerInfo var1);
    }
}

