/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackEventsListCopier;
import software.amazon.awssdk.services.codedeploy.transform.AutoRollbackConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoRollbackConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoRollbackConfiguration> {
    private final Boolean enabled;
    private final List<String> events;

    private AutoRollbackConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.events = builder.events;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<AutoRollbackEvent> events() {
        return TypeConverter.convert(this.events, AutoRollbackEvent::fromValue);
    }

    public List<String> eventsStrings() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.eventsStrings() == null ? 0 : this.eventsStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoRollbackConfiguration)) {
            return false;
        }
        AutoRollbackConfiguration other = (AutoRollbackConfiguration)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.eventsStrings() == null ^ this.eventsStrings() == null) {
            return false;
        }
        return other.eventsStrings() == null || other.eventsStrings().equals(this.eventsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.eventsStrings() != null) {
            sb.append("Events: ").append(this.eventsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "events": {
                return Optional.of(clazz.cast(this.eventsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoRollbackConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<String> events;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoRollbackConfiguration model) {
            this.enabled(model.enabled);
            this.events(model.events);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = AutoRollbackEventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = AutoRollbackEventsListCopier.copy(events);
        }

        public AutoRollbackConfiguration build() {
            return new AutoRollbackConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoRollbackConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);
    }
}

