/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOverview;

@SdkInternalApi
public class DeploymentOverviewMarshaller {
    private static final MarshallingInfo<Long> PENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pending").build();
    private static final MarshallingInfo<Long> INPROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InProgress").build();
    private static final MarshallingInfo<Long> SUCCEEDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Succeeded").build();
    private static final MarshallingInfo<Long> FAILED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Failed").build();
    private static final MarshallingInfo<Long> SKIPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Skipped").build();
    private static final MarshallingInfo<Long> READY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ready").build();
    private static final DeploymentOverviewMarshaller INSTANCE = new DeploymentOverviewMarshaller();

    public static DeploymentOverviewMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeploymentOverview deploymentOverview, ProtocolMarshaller protocolMarshaller) {
        if (deploymentOverview == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deploymentOverview.pending(), PENDING_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.inProgress(), INPROGRESS_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.succeeded(), SUCCEEDED_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.failed(), FAILED_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.skipped(), SKIPPED_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.ready(), READY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

