/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.DeploymentCreator;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOverview;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.ErrorInformation;
import software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.RollbackInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetInstances;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentInfo> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final String deploymentConfigName;
    private final String deploymentId;
    private final RevisionLocation previousRevision;
    private final RevisionLocation revision;
    private final String status;
    private final ErrorInformation errorInformation;
    private final Instant createTime;
    private final Instant startTime;
    private final Instant completeTime;
    private final DeploymentOverview deploymentOverview;
    private final String description;
    private final String creator;
    private final Boolean ignoreApplicationStopFailures;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final Boolean updateOutdatedInstancesOnly;
    private final RollbackInfo rollbackInfo;
    private final DeploymentStyle deploymentStyle;
    private final TargetInstances targetInstances;
    private final Boolean instanceTerminationWaitTimeStarted;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;
    private final String additionalDeploymentStatusInfo;
    private final String fileExistsBehavior;

    private DeploymentInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.deploymentId = builder.deploymentId;
        this.previousRevision = builder.previousRevision;
        this.revision = builder.revision;
        this.status = builder.status;
        this.errorInformation = builder.errorInformation;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.deploymentOverview = builder.deploymentOverview;
        this.description = builder.description;
        this.creator = builder.creator;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.rollbackInfo = builder.rollbackInfo;
        this.deploymentStyle = builder.deploymentStyle;
        this.targetInstances = builder.targetInstances;
        this.instanceTerminationWaitTimeStarted = builder.instanceTerminationWaitTimeStarted;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.additionalDeploymentStatusInfo = builder.additionalDeploymentStatusInfo;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public RevisionLocation previousRevision() {
        return this.previousRevision;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    public String status() {
        return this.status;
    }

    public ErrorInformation errorInformation() {
        return this.errorInformation;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant completeTime() {
        return this.completeTime;
    }

    public DeploymentOverview deploymentOverview() {
        return this.deploymentOverview;
    }

    public String description() {
        return this.description;
    }

    public String creator() {
        return this.creator;
    }

    public Boolean ignoreApplicationStopFailures() {
        return this.ignoreApplicationStopFailures;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public Boolean updateOutdatedInstancesOnly() {
        return this.updateOutdatedInstancesOnly;
    }

    public RollbackInfo rollbackInfo() {
        return this.rollbackInfo;
    }

    public DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public TargetInstances targetInstances() {
        return this.targetInstances;
    }

    public Boolean instanceTerminationWaitTimeStarted() {
        return this.instanceTerminationWaitTimeStarted;
    }

    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public String additionalDeploymentStatusInfo() {
        return this.additionalDeploymentStatusInfo;
    }

    public String fileExistsBehavior() {
        return this.fileExistsBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroupName() == null ? 0 : this.deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentConfigName() == null ? 0 : this.deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentId() == null ? 0 : this.deploymentId().hashCode());
        hashCode = 31 * hashCode + (this.previousRevision() == null ? 0 : this.previousRevision().hashCode());
        hashCode = 31 * hashCode + (this.revision() == null ? 0 : this.revision().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.errorInformation() == null ? 0 : this.errorInformation().hashCode());
        hashCode = 31 * hashCode + (this.createTime() == null ? 0 : this.createTime().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.completeTime() == null ? 0 : this.completeTime().hashCode());
        hashCode = 31 * hashCode + (this.deploymentOverview() == null ? 0 : this.deploymentOverview().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.creator() == null ? 0 : this.creator().hashCode());
        hashCode = 31 * hashCode + (this.ignoreApplicationStopFailures() == null ? 0 : this.ignoreApplicationStopFailures().hashCode());
        hashCode = 31 * hashCode + (this.autoRollbackConfiguration() == null ? 0 : this.autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.updateOutdatedInstancesOnly() == null ? 0 : this.updateOutdatedInstancesOnly().hashCode());
        hashCode = 31 * hashCode + (this.rollbackInfo() == null ? 0 : this.rollbackInfo().hashCode());
        hashCode = 31 * hashCode + (this.deploymentStyle() == null ? 0 : this.deploymentStyle().hashCode());
        hashCode = 31 * hashCode + (this.targetInstances() == null ? 0 : this.targetInstances().hashCode());
        hashCode = 31 * hashCode + (this.instanceTerminationWaitTimeStarted() == null ? 0 : this.instanceTerminationWaitTimeStarted().hashCode());
        hashCode = 31 * hashCode + (this.blueGreenDeploymentConfiguration() == null ? 0 : this.blueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerInfo() == null ? 0 : this.loadBalancerInfo().hashCode());
        hashCode = 31 * hashCode + (this.additionalDeploymentStatusInfo() == null ? 0 : this.additionalDeploymentStatusInfo().hashCode());
        hashCode = 31 * hashCode + (this.fileExistsBehavior() == null ? 0 : this.fileExistsBehavior().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentInfo)) {
            return false;
        }
        DeploymentInfo other = (DeploymentInfo)obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.previousRevision() == null ^ this.previousRevision() == null) {
            return false;
        }
        if (other.previousRevision() != null && !other.previousRevision().equals(this.previousRevision())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.errorInformation() == null ^ this.errorInformation() == null) {
            return false;
        }
        if (other.errorInformation() != null && !other.errorInformation().equals(this.errorInformation())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.completeTime() == null ^ this.completeTime() == null) {
            return false;
        }
        if (other.completeTime() != null && !other.completeTime().equals(this.completeTime())) {
            return false;
        }
        if (other.deploymentOverview() == null ^ this.deploymentOverview() == null) {
            return false;
        }
        if (other.deploymentOverview() != null && !other.deploymentOverview().equals(this.deploymentOverview())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.creator() == null ^ this.creator() == null) {
            return false;
        }
        if (other.creator() != null && !other.creator().equals(this.creator())) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() == null ^ this.ignoreApplicationStopFailures() == null) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() != null && !other.ignoreApplicationStopFailures().equals(this.ignoreApplicationStopFailures())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() == null ^ this.updateOutdatedInstancesOnly() == null) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() != null && !other.updateOutdatedInstancesOnly().equals(this.updateOutdatedInstancesOnly())) {
            return false;
        }
        if (other.rollbackInfo() == null ^ this.rollbackInfo() == null) {
            return false;
        }
        if (other.rollbackInfo() != null && !other.rollbackInfo().equals(this.rollbackInfo())) {
            return false;
        }
        if (other.deploymentStyle() == null ^ this.deploymentStyle() == null) {
            return false;
        }
        if (other.deploymentStyle() != null && !other.deploymentStyle().equals(this.deploymentStyle())) {
            return false;
        }
        if (other.targetInstances() == null ^ this.targetInstances() == null) {
            return false;
        }
        if (other.targetInstances() != null && !other.targetInstances().equals(this.targetInstances())) {
            return false;
        }
        if (other.instanceTerminationWaitTimeStarted() == null ^ this.instanceTerminationWaitTimeStarted() == null) {
            return false;
        }
        if (other.instanceTerminationWaitTimeStarted() != null && !other.instanceTerminationWaitTimeStarted().equals(this.instanceTerminationWaitTimeStarted())) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() == null ^ this.blueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() != null && !other.blueGreenDeploymentConfiguration().equals(this.blueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.loadBalancerInfo() == null ^ this.loadBalancerInfo() == null) {
            return false;
        }
        if (other.loadBalancerInfo() != null && !other.loadBalancerInfo().equals(this.loadBalancerInfo())) {
            return false;
        }
        if (other.additionalDeploymentStatusInfo() == null ^ this.additionalDeploymentStatusInfo() == null) {
            return false;
        }
        if (other.additionalDeploymentStatusInfo() != null && !other.additionalDeploymentStatusInfo().equals(this.additionalDeploymentStatusInfo())) {
            return false;
        }
        if (other.fileExistsBehavior() == null ^ this.fileExistsBehavior() == null) {
            return false;
        }
        return other.fileExistsBehavior() == null || other.fileExistsBehavior().equals(this.fileExistsBehavior());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.deploymentGroupName()).append(",");
        }
        if (this.deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.deploymentConfigName()).append(",");
        }
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.previousRevision() != null) {
            sb.append("PreviousRevision: ").append(this.previousRevision()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.errorInformation() != null) {
            sb.append("ErrorInformation: ").append(this.errorInformation()).append(",");
        }
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.completeTime() != null) {
            sb.append("CompleteTime: ").append(this.completeTime()).append(",");
        }
        if (this.deploymentOverview() != null) {
            sb.append("DeploymentOverview: ").append(this.deploymentOverview()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.creator() != null) {
            sb.append("Creator: ").append(this.creator()).append(",");
        }
        if (this.ignoreApplicationStopFailures() != null) {
            sb.append("IgnoreApplicationStopFailures: ").append(this.ignoreApplicationStopFailures()).append(",");
        }
        if (this.autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.autoRollbackConfiguration()).append(",");
        }
        if (this.updateOutdatedInstancesOnly() != null) {
            sb.append("UpdateOutdatedInstancesOnly: ").append(this.updateOutdatedInstancesOnly()).append(",");
        }
        if (this.rollbackInfo() != null) {
            sb.append("RollbackInfo: ").append(this.rollbackInfo()).append(",");
        }
        if (this.deploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(this.deploymentStyle()).append(",");
        }
        if (this.targetInstances() != null) {
            sb.append("TargetInstances: ").append(this.targetInstances()).append(",");
        }
        if (this.instanceTerminationWaitTimeStarted() != null) {
            sb.append("InstanceTerminationWaitTimeStarted: ").append(this.instanceTerminationWaitTimeStarted()).append(",");
        }
        if (this.blueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(this.blueGreenDeploymentConfiguration()).append(",");
        }
        if (this.loadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(this.loadBalancerInfo()).append(",");
        }
        if (this.additionalDeploymentStatusInfo() != null) {
            sb.append("AdditionalDeploymentStatusInfo: ").append(this.additionalDeploymentStatusInfo()).append(",");
        }
        if (this.fileExistsBehavior() != null) {
            sb.append("FileExistsBehavior: ").append(this.fileExistsBehavior()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private String deploymentConfigName;
        private String deploymentId;
        private RevisionLocation previousRevision;
        private RevisionLocation revision;
        private String status;
        private ErrorInformation errorInformation;
        private Instant createTime;
        private Instant startTime;
        private Instant completeTime;
        private DeploymentOverview deploymentOverview;
        private String description;
        private String creator;
        private Boolean ignoreApplicationStopFailures;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private Boolean updateOutdatedInstancesOnly;
        private RollbackInfo rollbackInfo;
        private DeploymentStyle deploymentStyle;
        private TargetInstances targetInstances;
        private Boolean instanceTerminationWaitTimeStarted;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;
        private String additionalDeploymentStatusInfo;
        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentInfo model) {
            this.setApplicationName(model.applicationName);
            this.setDeploymentGroupName(model.deploymentGroupName);
            this.setDeploymentConfigName(model.deploymentConfigName);
            this.setDeploymentId(model.deploymentId);
            this.setPreviousRevision(model.previousRevision);
            this.setRevision(model.revision);
            this.setStatus(model.status);
            this.setErrorInformation(model.errorInformation);
            this.setCreateTime(model.createTime);
            this.setStartTime(model.startTime);
            this.setCompleteTime(model.completeTime);
            this.setDeploymentOverview(model.deploymentOverview);
            this.setDescription(model.description);
            this.setCreator(model.creator);
            this.setIgnoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            this.setAutoRollbackConfiguration(model.autoRollbackConfiguration);
            this.setUpdateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            this.setRollbackInfo(model.rollbackInfo);
            this.setDeploymentStyle(model.deploymentStyle);
            this.setTargetInstances(model.targetInstances);
            this.setInstanceTerminationWaitTimeStarted(model.instanceTerminationWaitTimeStarted);
            this.setBlueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.setLoadBalancerInfo(model.loadBalancerInfo);
            this.setAdditionalDeploymentStatusInfo(model.additionalDeploymentStatusInfo);
            this.setFileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final RevisionLocation getPreviousRevision() {
            return this.previousRevision;
        }

        @Override
        public final Builder previousRevision(RevisionLocation previousRevision) {
            this.previousRevision = previousRevision;
            return this;
        }

        public final void setPreviousRevision(RevisionLocation previousRevision) {
            this.previousRevision = previousRevision;
        }

        public final RevisionLocation getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation revision) {
            this.revision = revision;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(DeploymentStatus status) {
            this.status(status.toString());
        }

        public final ErrorInformation getErrorInformation() {
            return this.errorInformation;
        }

        @Override
        public final Builder errorInformation(ErrorInformation errorInformation) {
            this.errorInformation = errorInformation;
            return this;
        }

        public final void setErrorInformation(ErrorInformation errorInformation) {
            this.errorInformation = errorInformation;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getCompleteTime() {
            return this.completeTime;
        }

        @Override
        public final Builder completeTime(Instant completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final void setCompleteTime(Instant completeTime) {
            this.completeTime = completeTime;
        }

        public final DeploymentOverview getDeploymentOverview() {
            return this.deploymentOverview;
        }

        @Override
        public final Builder deploymentOverview(DeploymentOverview deploymentOverview) {
            this.deploymentOverview = deploymentOverview;
            return this;
        }

        public final void setDeploymentOverview(DeploymentOverview deploymentOverview) {
            this.deploymentOverview = deploymentOverview;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCreator() {
            return this.creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        @Override
        public final Builder creator(DeploymentCreator creator) {
            this.creator(creator.toString());
            return this;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        public final void setCreator(DeploymentCreator creator) {
            this.creator(creator.toString());
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return this.ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        public final AutoRollbackConfiguration getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return this.updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        public final RollbackInfo getRollbackInfo() {
            return this.rollbackInfo;
        }

        @Override
        public final Builder rollbackInfo(RollbackInfo rollbackInfo) {
            this.rollbackInfo = rollbackInfo;
            return this;
        }

        public final void setRollbackInfo(RollbackInfo rollbackInfo) {
            this.rollbackInfo = rollbackInfo;
        }

        public final DeploymentStyle getDeploymentStyle() {
            return this.deploymentStyle;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
        }

        public final TargetInstances getTargetInstances() {
            return this.targetInstances;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final void setTargetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
        }

        public final Boolean getInstanceTerminationWaitTimeStarted() {
            return this.instanceTerminationWaitTimeStarted;
        }

        @Override
        public final Builder instanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
            return this;
        }

        public final void setInstanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
        }

        public final BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
        }

        public final LoadBalancerInfo getLoadBalancerInfo() {
            return this.loadBalancerInfo;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
        }

        public final String getAdditionalDeploymentStatusInfo() {
            return this.additionalDeploymentStatusInfo;
        }

        @Override
        public final Builder additionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
            return this;
        }

        public final void setAdditionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
        }

        public final String getFileExistsBehavior() {
            return this.fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
            return this;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        public final void setFileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
        }

        public DeploymentInfo build() {
            return new DeploymentInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentInfo> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder deploymentId(String var1);

        public Builder previousRevision(RevisionLocation var1);

        public Builder revision(RevisionLocation var1);

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder errorInformation(ErrorInformation var1);

        public Builder createTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completeTime(Instant var1);

        public Builder deploymentOverview(DeploymentOverview var1);

        public Builder description(String var1);

        public Builder creator(String var1);

        public Builder creator(DeploymentCreator var1);

        public Builder ignoreApplicationStopFailures(Boolean var1);

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        public Builder updateOutdatedInstancesOnly(Boolean var1);

        public Builder rollbackInfo(RollbackInfo var1);

        public Builder deploymentStyle(DeploymentStyle var1);

        public Builder targetInstances(TargetInstances var1);

        public Builder instanceTerminationWaitTimeStarted(Boolean var1);

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        public Builder loadBalancerInfo(LoadBalancerInfo var1);

        public Builder additionalDeploymentStatusInfo(String var1);

        public Builder fileExistsBehavior(String var1);

        public Builder fileExistsBehavior(FileExistsBehavior var1);
    }
}

