/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.InstancesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentInstancesResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListDeploymentInstancesResponse> {
    private static final SdkField<List<String>> INSTANCES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDeploymentInstancesResponse.getter(ListDeploymentInstancesResponse::instancesList)).setter(ListDeploymentInstancesResponse.setter(Builder::instancesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instancesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeploymentInstancesResponse.getter(ListDeploymentInstancesResponse::nextToken)).setter(ListDeploymentInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> instancesList;
    private final String nextToken;

    private ListDeploymentInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instancesList = builder.instancesList;
        this.nextToken = builder.nextToken;
    }

    public List<String> instancesList() {
        return this.instancesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesResponse)) {
            return false;
        }
        ListDeploymentInstancesResponse other = (ListDeploymentInstancesResponse)((Object)obj);
        return Objects.equals(this.instancesList(), other.instancesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentInstancesResponse").add("InstancesList", this.instancesList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instancesList": {
                return Optional.ofNullable(clazz.cast(this.instancesList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentInstancesResponse, T> g) {
        return obj -> g.apply((ListDeploymentInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<String> instancesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentInstancesResponse model) {
            super(model);
            this.instancesList(model.instancesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getInstancesList() {
            return this.instancesList;
        }

        @Override
        public final Builder instancesList(Collection<String> instancesList) {
            this.instancesList = InstancesListCopier.copy(instancesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesList(String ... instancesList) {
            this.instancesList(Arrays.asList(instancesList));
            return this;
        }

        public final void setInstancesList(Collection<String> instancesList) {
            this.instancesList = InstancesListCopier.copy(instancesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentInstancesResponse build() {
            return new ListDeploymentInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentInstancesResponse> {
        public Builder instancesList(Collection<String> var1);

        public Builder instancesList(String ... var1);

        public Builder nextToken(String var1);
    }
}

