/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.RawStringMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RawString
implements StructuredPojo,
ToCopyableBuilder<Builder, RawString> {
    private final String content;
    private final String sha256;

    private RawString(BuilderImpl builder) {
        this.content = builder.content;
        this.sha256 = builder.sha256;
    }

    public String content() {
        return this.content;
    }

    public String sha256() {
        return this.sha256;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawString)) {
            return false;
        }
        RawString other = (RawString)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.sha256(), other.sha256());
    }

    public String toString() {
        return ToString.builder((String)"RawString").add("Content", (Object)this.content()).add("Sha256", (Object)this.sha256()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "sha256": {
                return Optional.ofNullable(clazz.cast(this.sha256()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RawStringMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String sha256;

        private BuilderImpl() {
        }

        private BuilderImpl(RawString model) {
            this.content(model.content);
            this.sha256(model.sha256);
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getSha256() {
            return this.sha256;
        }

        @Override
        public final Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public final void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        public RawString build() {
            return new RawString(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RawString> {
        public Builder content(String var1);

        public Builder sha256(String var1);
    }
}

