/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatusListCopier;
import software.amazon.awssdk.services.codedeploy.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, ListDeploymentsRequest> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final List<String> includeOnlyStatuses;
    private final TimeRange createTimeRange;
    private final String nextToken;

    private ListDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.includeOnlyStatuses = builder.includeOnlyStatuses;
        this.createTimeRange = builder.createTimeRange;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public List<DeploymentStatus> includeOnlyStatuses() {
        return TypeConverter.convert(this.includeOnlyStatuses, DeploymentStatus::fromValue);
    }

    public List<String> includeOnlyStatusesAsStrings() {
        return this.includeOnlyStatuses;
    }

    public TimeRange createTimeRange() {
        return this.createTimeRange;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeOnlyStatusesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.includeOnlyStatusesAsStrings(), other.includeOnlyStatusesAsStrings()) && Objects.equals(this.createTimeRange(), other.createTimeRange()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentsRequest").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupName", (Object)this.deploymentGroupName()).add("IncludeOnlyStatuses", this.includeOnlyStatusesAsStrings()).add("CreateTimeRange", (Object)this.createTimeRange()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupName()));
            }
            case "includeOnlyStatuses": {
                return Optional.ofNullable(clazz.cast(this.includeOnlyStatusesAsStrings()));
            }
            case "createTimeRange": {
                return Optional.ofNullable(clazz.cast(this.createTimeRange()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private List<String> includeOnlyStatuses = DefaultSdkAutoConstructList.getInstance();
        private TimeRange createTimeRange;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.includeOnlyStatusesWithStrings(model.includeOnlyStatuses);
            this.createTimeRange(model.createTimeRange);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final Collection<String> getIncludeOnlyStatuses() {
            return this.includeOnlyStatuses;
        }

        @Override
        public final Builder includeOnlyStatusesWithStrings(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatusesWithStrings(String ... includeOnlyStatuses) {
            this.includeOnlyStatusesWithStrings(Arrays.asList(includeOnlyStatuses));
            return this;
        }

        @Override
        public final Builder includeOnlyStatuses(Collection<DeploymentStatus> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copyEnumToString(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(DeploymentStatus ... includeOnlyStatuses) {
            this.includeOnlyStatuses(Arrays.asList(includeOnlyStatuses));
            return this;
        }

        public final void setIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
        }

        public final TimeRange.Builder getCreateTimeRange() {
            return this.createTimeRange != null ? this.createTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder createTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
            return this;
        }

        public final void setCreateTimeRange(TimeRange.BuilderImpl createTimeRange) {
            this.createTimeRange = createTimeRange != null ? createTimeRange.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeploymentsRequest build() {
            return new ListDeploymentsRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, ListDeploymentsRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder includeOnlyStatusesWithStrings(Collection<String> var1);

        public Builder includeOnlyStatusesWithStrings(String ... var1);

        public Builder includeOnlyStatuses(Collection<DeploymentStatus> var1);

        public Builder includeOnlyStatuses(DeploymentStatus ... var1);

        public Builder createTimeRange(TimeRange var1);

        default public Builder createTimeRange(Consumer<TimeRange.Builder> createTimeRange) {
            return this.createTimeRange((TimeRange)((TimeRange.Builder)TimeRange.builder().applyMutation(createTimeRange)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

