/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;

public class ListApplicationRevisionsPublisher
implements SdkPublisher<ListApplicationRevisionsResponse> {
    private final CodeDeployAsyncClient client;
    private final ListApplicationRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationRevisionsPublisher(CodeDeployAsyncClient client, ListApplicationRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationRevisionsPublisher(CodeDeployAsyncClient client, ListApplicationRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RevisionLocation> revisions() {
        Function<ListApplicationRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.revisions() != null) {
                return response.revisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListApplicationRevisionsPublisher resume(ListApplicationRevisionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListApplicationRevisionsPublisher(this.client, (ListApplicationRevisionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListApplicationRevisionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListApplicationRevisionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListApplicationRevisionsResponseFetcher
    implements AsyncPageFetcher<ListApplicationRevisionsResponse> {
        private ListApplicationRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationRevisionsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationRevisionsResponse> nextPage(ListApplicationRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationRevisionsPublisher.this.client.listApplicationRevisions(ListApplicationRevisionsPublisher.this.firstRequest);
            }
            return ListApplicationRevisionsPublisher.this.client.listApplicationRevisions((ListApplicationRevisionsRequest)((Object)ListApplicationRevisionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

