/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode;
import software.amazon.awssdk.services.codedeploy.transform.DiagnosticsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Diagnostics
implements StructuredPojo,
ToCopyableBuilder<Builder, Diagnostics> {
    private final String errorCode;
    private final String scriptName;
    private final String message;
    private final String logTail;

    private Diagnostics(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.scriptName = builder.scriptName;
        this.message = builder.message;
        this.logTail = builder.logTail;
    }

    public LifecycleErrorCode errorCode() {
        return LifecycleErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String scriptName() {
        return this.scriptName;
    }

    public String message() {
        return this.message;
    }

    public String logTail() {
        return this.logTail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptName());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Diagnostics)) {
            return false;
        }
        Diagnostics other = (Diagnostics)obj;
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.scriptName(), other.scriptName()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.logTail(), other.logTail());
    }

    public String toString() {
        return ToString.builder((String)"Diagnostics").add("ErrorCode", (Object)this.errorCodeAsString()).add("ScriptName", (Object)this.scriptName()).add("Message", (Object)this.message()).add("LogTail", (Object)this.logTail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "scriptName": {
                return Optional.ofNullable(clazz.cast(this.scriptName()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "logTail": {
                return Optional.ofNullable(clazz.cast(this.logTail()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiagnosticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String scriptName;
        private String message;
        private String logTail;

        private BuilderImpl() {
        }

        private BuilderImpl(Diagnostics model) {
            this.errorCode(model.errorCode);
            this.scriptName(model.scriptName);
            this.message(model.message);
            this.logTail(model.logTail);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(LifecycleErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getScriptName() {
            return this.scriptName;
        }

        @Override
        public final Builder scriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public final void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogTail() {
            return this.logTail;
        }

        @Override
        public final Builder logTail(String logTail) {
            this.logTail = logTail;
            return this;
        }

        public final void setLogTail(String logTail) {
            this.logTail = logTail;
        }

        public Diagnostics build() {
            return new Diagnostics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Diagnostics> {
        public Builder errorCode(String var1);

        public Builder errorCode(LifecycleErrorCode var1);

        public Builder scriptName(String var1);

        public Builder message(String var1);

        public Builder logTail(String var1);
    }
}

