/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentConfigInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfigInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentConfigInfo> {
    private final String deploymentConfigId;
    private final String deploymentConfigName;
    private final MinimumHealthyHosts minimumHealthyHosts;
    private final Instant createTime;

    private DeploymentConfigInfo(BuilderImpl builder) {
        this.deploymentConfigId = builder.deploymentConfigId;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.createTime = builder.createTime;
    }

    public String deploymentConfigId() {
        return this.deploymentConfigId;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public MinimumHealthyHosts minimumHealthyHosts() {
        return this.minimumHealthyHosts;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfigInfo)) {
            return false;
        }
        DeploymentConfigInfo other = (DeploymentConfigInfo)obj;
        return Objects.equals(this.deploymentConfigId(), other.deploymentConfigId()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.minimumHealthyHosts(), other.minimumHealthyHosts()) && Objects.equals(this.createTime(), other.createTime());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentConfigInfo").add("DeploymentConfigId", (Object)this.deploymentConfigId()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("MinimumHealthyHosts", (Object)this.minimumHealthyHosts()).add("CreateTime", (Object)this.createTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigId": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigId()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "minimumHealthyHosts": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyHosts()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentConfigInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentConfigId;
        private String deploymentConfigName;
        private MinimumHealthyHosts minimumHealthyHosts;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfigInfo model) {
            this.deploymentConfigId(model.deploymentConfigId);
            this.deploymentConfigName(model.deploymentConfigName);
            this.minimumHealthyHosts(model.minimumHealthyHosts);
            this.createTime(model.createTime);
        }

        public final String getDeploymentConfigId() {
            return this.deploymentConfigId;
        }

        @Override
        public final Builder deploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
            return this;
        }

        public final void setDeploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return this.minimumHealthyHosts != null ? this.minimumHealthyHosts.toBuilder() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public DeploymentConfigInfo build() {
            return new DeploymentConfigInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentConfigInfo> {
        public Builder deploymentConfigId(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder minimumHealthyHosts(MinimumHealthyHosts var1);

        default public Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return this.minimumHealthyHosts((MinimumHealthyHosts)((MinimumHealthyHosts.Builder)MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts)).build());
        }

        public Builder createTime(Instant var1);
    }
}

