/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopDeploymentRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, StopDeploymentRequest> {
    private final String deploymentId;
    private final Boolean autoRollbackEnabled;

    private StopDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.autoRollbackEnabled = builder.autoRollbackEnabled;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public Boolean autoRollbackEnabled() {
        return this.autoRollbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentRequest)) {
            return false;
        }
        StopDeploymentRequest other = (StopDeploymentRequest)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.autoRollbackEnabled(), other.autoRollbackEnabled());
    }

    public String toString() {
        return ToString.builder((String)"StopDeploymentRequest").add("DeploymentId", (Object)this.deploymentId()).add("AutoRollbackEnabled", (Object)this.autoRollbackEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "autoRollbackEnabled": {
                return Optional.of(clazz.cast(this.autoRollbackEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String deploymentId;
        private Boolean autoRollbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentRequest model) {
            super(model);
            this.deploymentId(model.deploymentId);
            this.autoRollbackEnabled(model.autoRollbackEnabled);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final Boolean getAutoRollbackEnabled() {
            return this.autoRollbackEnabled;
        }

        @Override
        public final Builder autoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
            return this;
        }

        public final void setAutoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StopDeploymentRequest build() {
            return new StopDeploymentRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, StopDeploymentRequest> {
        public Builder deploymentId(String var1);

        public Builder autoRollbackEnabled(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

