/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterOnPremisesInstanceRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
    private final String instanceName;
    private final String iamSessionArn;
    private final String iamUserArn;

    private RegisterOnPremisesInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String iamSessionArn() {
        return this.iamSessionArn;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterOnPremisesInstanceRequest)) {
            return false;
        }
        RegisterOnPremisesInstanceRequest other = (RegisterOnPremisesInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.iamSessionArn(), other.iamSessionArn()) && Objects.equals(this.iamUserArn(), other.iamUserArn());
    }

    public String toString() {
        return ToString.builder((String)"RegisterOnPremisesInstanceRequest").add("InstanceName", (Object)this.instanceName()).add("IamSessionArn", (Object)this.iamSessionArn()).add("IamUserArn", (Object)this.iamUserArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "iamSessionArn": {
                return Optional.of(clazz.cast(this.iamSessionArn()));
            }
            case "iamUserArn": {
                return Optional.of(clazz.cast(this.iamUserArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private String iamSessionArn;
        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterOnPremisesInstanceRequest model) {
            super(model);
            this.instanceName(model.instanceName);
            this.iamSessionArn(model.iamSessionArn);
            this.iamUserArn(model.iamUserArn);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return this.iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterOnPremisesInstanceRequest build() {
            return new RegisterOnPremisesInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
        public Builder instanceName(String var1);

        public Builder iamSessionArn(String var1);

        public Builder iamUserArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

