/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.waiters.DeploymentSuccessful;
import software.amazon.awssdk.services.codedeploy.waiters.GetDeploymentFunction;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class CodeDeployClientWaiters {
    private final CodeDeployClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public CodeDeployClientWaiters(CodeDeployClient client) {
        this.client = client;
    }

    public Waiter<GetDeploymentRequest> deploymentSuccessful() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetDeploymentFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DeploymentSuccessful.IsSucceededMatcher(), new DeploymentSuccessful.IsFailedMatcher(), new DeploymentSuccessful.IsStoppedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

