/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatusListCopier;
import software.amazon.awssdk.services.codedeploy.model.TimeRange;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListDeploymentsRequest> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final List<String> includeOnlyStatuses;
    private final TimeRange createTimeRange;
    private final String nextToken;

    private ListDeploymentsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.includeOnlyStatuses = builder.includeOnlyStatuses;
        this.createTimeRange = builder.createTimeRange;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public List<String> includeOnlyStatuses() {
        return this.includeOnlyStatuses;
    }

    public TimeRange createTimeRange() {
        return this.createTimeRange;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroupName() == null ? 0 : this.deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.includeOnlyStatuses() == null ? 0 : this.includeOnlyStatuses().hashCode());
        hashCode = 31 * hashCode + (this.createTimeRange() == null ? 0 : this.createTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.includeOnlyStatuses() == null ^ this.includeOnlyStatuses() == null) {
            return false;
        }
        if (other.includeOnlyStatuses() != null && !other.includeOnlyStatuses().equals(this.includeOnlyStatuses())) {
            return false;
        }
        if (other.createTimeRange() == null ^ this.createTimeRange() == null) {
            return false;
        }
        if (other.createTimeRange() != null && !other.createTimeRange().equals(this.createTimeRange())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.deploymentGroupName()).append(",");
        }
        if (this.includeOnlyStatuses() != null) {
            sb.append("IncludeOnlyStatuses: ").append(this.includeOnlyStatuses()).append(",");
        }
        if (this.createTimeRange() != null) {
            sb.append("CreateTimeRange: ").append(this.createTimeRange()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private List<String> includeOnlyStatuses = new SdkInternalList();
        private TimeRange createTimeRange;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsRequest model) {
            this.setApplicationName(model.applicationName);
            this.setDeploymentGroupName(model.deploymentGroupName);
            this.setIncludeOnlyStatuses(model.includeOnlyStatuses);
            this.setCreateTimeRange(model.createTimeRange);
            this.setNextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final Collection<String> getIncludeOnlyStatuses() {
            return this.includeOnlyStatuses;
        }

        @Override
        public final Builder includeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(String ... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList(includeOnlyStatuses.length);
            }
            for (String e : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(DeploymentStatus ... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList(includeOnlyStatuses.length);
            }
            for (DeploymentStatus ele : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(ele.toString());
            }
            return this;
        }

        public final void setIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
        }

        @SafeVarargs
        public final void setIncludeOnlyStatuses(String ... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList(includeOnlyStatuses.length);
            }
            for (String e : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(e);
            }
        }

        @SafeVarargs
        public final void setIncludeOnlyStatuses(DeploymentStatus ... includeOnlyStatuses) {
            if (this.includeOnlyStatuses == null) {
                this.includeOnlyStatuses = new SdkInternalList(includeOnlyStatuses.length);
            }
            for (DeploymentStatus ele : includeOnlyStatuses) {
                this.includeOnlyStatuses.add(ele.toString());
            }
        }

        public final TimeRange getCreateTimeRange() {
            return this.createTimeRange;
        }

        @Override
        public final Builder createTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
            return this;
        }

        public final void setCreateTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDeploymentsRequest build() {
            return new ListDeploymentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeploymentsRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder includeOnlyStatuses(Collection<String> var1);

        public Builder includeOnlyStatuses(String ... var1);

        public Builder includeOnlyStatuses(DeploymentStatus ... var1);

        public Builder createTimeRange(TimeRange var1);

        public Builder nextToken(String var1);
    }
}

