/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsRequest;
import software.amazon.awssdk.services.codeconnections.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHostRequest
extends CodeConnectionsRequest
implements ToCopyableBuilder<Builder, UpdateHostRequest> {
    private static final SdkField<String> HOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostArn").getter(UpdateHostRequest.getter(UpdateHostRequest::hostArn)).setter(UpdateHostRequest.setter(Builder::hostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostArn").build()}).build();
    private static final SdkField<String> PROVIDER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderEndpoint").getter(UpdateHostRequest.getter(UpdateHostRequest::providerEndpoint)).setter(UpdateHostRequest.setter(Builder::providerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderEndpoint").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(UpdateHostRequest.getter(UpdateHostRequest::vpcConfiguration)).setter(UpdateHostRequest.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ARN_FIELD, PROVIDER_ENDPOINT_FIELD, VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateHostRequest.memberNameToFieldInitializer();
    private final String hostArn;
    private final String providerEndpoint;
    private final VpcConfiguration vpcConfiguration;

    private UpdateHostRequest(BuilderImpl builder) {
        super(builder);
        this.hostArn = builder.hostArn;
        this.providerEndpoint = builder.providerEndpoint;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String hostArn() {
        return this.hostArn;
    }

    public final String providerEndpoint() {
        return this.providerEndpoint;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostRequest)) {
            return false;
        }
        UpdateHostRequest other = (UpdateHostRequest)((Object)obj);
        return Objects.equals(this.hostArn(), other.hostArn()) && Objects.equals(this.providerEndpoint(), other.providerEndpoint()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHostRequest").add("HostArn", (Object)this.hostArn()).add("ProviderEndpoint", (Object)this.providerEndpoint()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostArn": {
                return Optional.ofNullable(clazz.cast(this.hostArn()));
            }
            case "ProviderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.providerEndpoint()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostArn", HOST_ARN_FIELD);
        map.put("ProviderEndpoint", PROVIDER_ENDPOINT_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostRequest, T> g) {
        return obj -> g.apply((UpdateHostRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeConnectionsRequest.BuilderImpl
    implements Builder {
        private String hostArn;
        private String providerEndpoint;
        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostRequest model) {
            super(model);
            this.hostArn(model.hostArn);
            this.providerEndpoint(model.providerEndpoint);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getHostArn() {
            return this.hostArn;
        }

        public final void setHostArn(String hostArn) {
            this.hostArn = hostArn;
        }

        @Override
        public final Builder hostArn(String hostArn) {
            this.hostArn = hostArn;
            return this;
        }

        public final String getProviderEndpoint() {
            return this.providerEndpoint;
        }

        public final void setProviderEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
        }

        @Override
        public final Builder providerEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHostRequest build() {
            return new UpdateHostRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeConnectionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHostRequest> {
        public Builder hostArn(String var1);

        public Builder providerEndpoint(String var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

