/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsResponse;
import software.amazon.awssdk.services.codeconnections.model.ProviderType;
import software.amazon.awssdk.services.codeconnections.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHostResponse
extends CodeConnectionsResponse
implements ToCopyableBuilder<Builder, GetHostResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetHostResponse.getter(GetHostResponse::name)).setter(GetHostResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetHostResponse.getter(GetHostResponse::status)).setter(GetHostResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(GetHostResponse.getter(GetHostResponse::providerTypeAsString)).setter(GetHostResponse.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> PROVIDER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderEndpoint").getter(GetHostResponse.getter(GetHostResponse::providerEndpoint)).setter(GetHostResponse.setter(Builder::providerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderEndpoint").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(GetHostResponse.getter(GetHostResponse::vpcConfiguration)).setter(GetHostResponse.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, PROVIDER_TYPE_FIELD, PROVIDER_ENDPOINT_FIELD, VPC_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetHostResponse.memberNameToFieldInitializer();
    private final String name;
    private final String status;
    private final String providerType;
    private final String providerEndpoint;
    private final VpcConfiguration vpcConfiguration;

    private GetHostResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.status = builder.status;
        this.providerType = builder.providerType;
        this.providerEndpoint = builder.providerEndpoint;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final String providerEndpoint() {
        return this.providerEndpoint;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostResponse)) {
            return false;
        }
        GetHostResponse other = (GetHostResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.providerEndpoint(), other.providerEndpoint()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetHostResponse").add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("ProviderType", (Object)this.providerTypeAsString()).add("ProviderEndpoint", (Object)this.providerEndpoint()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "ProviderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.providerEndpoint()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("ProviderEndpoint", PROVIDER_ENDPOINT_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHostResponse, T> g) {
        return obj -> g.apply((GetHostResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeConnectionsResponse.BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String providerType;
        private String providerEndpoint;
        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostResponse model) {
            super(model);
            this.name(model.name);
            this.status(model.status);
            this.providerType(model.providerType);
            this.providerEndpoint(model.providerEndpoint);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getProviderEndpoint() {
            return this.providerEndpoint;
        }

        public final void setProviderEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
        }

        @Override
        public final Builder providerEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public GetHostResponse build() {
            return new GetHostResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeConnectionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHostResponse> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder providerEndpoint(String var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

