/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsRequest;
import software.amazon.awssdk.services.codeconnections.model.PublishDeploymentStatus;
import software.amazon.awssdk.services.codeconnections.model.PullRequestComment;
import software.amazon.awssdk.services.codeconnections.model.SyncConfigurationType;
import software.amazon.awssdk.services.codeconnections.model.TriggerResourceUpdateOn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSyncConfigurationRequest
extends CodeConnectionsRequest
implements ToCopyableBuilder<Builder, CreateSyncConfigurationRequest> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Branch").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::branch)).setter(CreateSyncConfigurationRequest.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()}).build();
    private static final SdkField<String> CONFIG_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigFile").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::configFile)).setter(CreateSyncConfigurationRequest.setter(Builder::configFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()}).build();
    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryLinkId").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::repositoryLinkId)).setter(CreateSyncConfigurationRequest.setter(Builder::repositoryLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::resourceName)).setter(CreateSyncConfigurationRequest.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::roleArn)).setter(CreateSyncConfigurationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncType").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::syncTypeAsString)).setter(CreateSyncConfigurationRequest.setter(Builder::syncType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()}).build();
    private static final SdkField<String> PUBLISH_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishDeploymentStatus").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::publishDeploymentStatusAsString)).setter(CreateSyncConfigurationRequest.setter(Builder::publishDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishDeploymentStatus").build()}).build();
    private static final SdkField<String> TRIGGER_RESOURCE_UPDATE_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerResourceUpdateOn").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::triggerResourceUpdateOnAsString)).setter(CreateSyncConfigurationRequest.setter(Builder::triggerResourceUpdateOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerResourceUpdateOn").build()}).build();
    private static final SdkField<String> PULL_REQUEST_COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PullRequestComment").getter(CreateSyncConfigurationRequest.getter(CreateSyncConfigurationRequest::pullRequestCommentAsString)).setter(CreateSyncConfigurationRequest.setter(Builder::pullRequestComment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PullRequestComment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, CONFIG_FILE_FIELD, REPOSITORY_LINK_ID_FIELD, RESOURCE_NAME_FIELD, ROLE_ARN_FIELD, SYNC_TYPE_FIELD, PUBLISH_DEPLOYMENT_STATUS_FIELD, TRIGGER_RESOURCE_UPDATE_ON_FIELD, PULL_REQUEST_COMMENT_FIELD));
    private final String branch;
    private final String configFile;
    private final String repositoryLinkId;
    private final String resourceName;
    private final String roleArn;
    private final String syncType;
    private final String publishDeploymentStatus;
    private final String triggerResourceUpdateOn;
    private final String pullRequestComment;

    private CreateSyncConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
        this.configFile = builder.configFile;
        this.repositoryLinkId = builder.repositoryLinkId;
        this.resourceName = builder.resourceName;
        this.roleArn = builder.roleArn;
        this.syncType = builder.syncType;
        this.publishDeploymentStatus = builder.publishDeploymentStatus;
        this.triggerResourceUpdateOn = builder.triggerResourceUpdateOn;
        this.pullRequestComment = builder.pullRequestComment;
    }

    public final String branch() {
        return this.branch;
    }

    public final String configFile() {
        return this.configFile;
    }

    public final String repositoryLinkId() {
        return this.repositoryLinkId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(this.syncType);
    }

    public final String syncTypeAsString() {
        return this.syncType;
    }

    public final PublishDeploymentStatus publishDeploymentStatus() {
        return PublishDeploymentStatus.fromValue(this.publishDeploymentStatus);
    }

    public final String publishDeploymentStatusAsString() {
        return this.publishDeploymentStatus;
    }

    public final TriggerResourceUpdateOn triggerResourceUpdateOn() {
        return TriggerResourceUpdateOn.fromValue(this.triggerResourceUpdateOn);
    }

    public final String triggerResourceUpdateOnAsString() {
        return this.triggerResourceUpdateOn;
    }

    public final PullRequestComment pullRequestComment() {
        return PullRequestComment.fromValue(this.pullRequestComment);
    }

    public final String pullRequestCommentAsString() {
        return this.pullRequestComment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.configFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerResourceUpdateOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestCommentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSyncConfigurationRequest)) {
            return false;
        }
        CreateSyncConfigurationRequest other = (CreateSyncConfigurationRequest)((Object)obj);
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.configFile(), other.configFile()) && Objects.equals(this.repositoryLinkId(), other.repositoryLinkId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.syncTypeAsString(), other.syncTypeAsString()) && Objects.equals(this.publishDeploymentStatusAsString(), other.publishDeploymentStatusAsString()) && Objects.equals(this.triggerResourceUpdateOnAsString(), other.triggerResourceUpdateOnAsString()) && Objects.equals(this.pullRequestCommentAsString(), other.pullRequestCommentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSyncConfigurationRequest").add("Branch", (Object)this.branch()).add("ConfigFile", (Object)this.configFile()).add("RepositoryLinkId", (Object)this.repositoryLinkId()).add("ResourceName", (Object)this.resourceName()).add("RoleArn", (Object)this.roleArn()).add("SyncType", (Object)this.syncTypeAsString()).add("PublishDeploymentStatus", (Object)this.publishDeploymentStatusAsString()).add("TriggerResourceUpdateOn", (Object)this.triggerResourceUpdateOnAsString()).add("PullRequestComment", (Object)this.pullRequestCommentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "ConfigFile": {
                return Optional.ofNullable(clazz.cast(this.configFile()));
            }
            case "RepositoryLinkId": {
                return Optional.ofNullable(clazz.cast(this.repositoryLinkId()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SyncType": {
                return Optional.ofNullable(clazz.cast(this.syncTypeAsString()));
            }
            case "PublishDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.publishDeploymentStatusAsString()));
            }
            case "TriggerResourceUpdateOn": {
                return Optional.ofNullable(clazz.cast(this.triggerResourceUpdateOnAsString()));
            }
            case "PullRequestComment": {
                return Optional.ofNullable(clazz.cast(this.pullRequestCommentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSyncConfigurationRequest, T> g) {
        return obj -> g.apply((CreateSyncConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeConnectionsRequest.BuilderImpl
    implements Builder {
        private String branch;
        private String configFile;
        private String repositoryLinkId;
        private String resourceName;
        private String roleArn;
        private String syncType;
        private String publishDeploymentStatus;
        private String triggerResourceUpdateOn;
        private String pullRequestComment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSyncConfigurationRequest model) {
            super(model);
            this.branch(model.branch);
            this.configFile(model.configFile);
            this.repositoryLinkId(model.repositoryLinkId);
            this.resourceName(model.resourceName);
            this.roleArn(model.roleArn);
            this.syncType(model.syncType);
            this.publishDeploymentStatus(model.publishDeploymentStatus);
            this.triggerResourceUpdateOn(model.triggerResourceUpdateOn);
            this.pullRequestComment(model.pullRequestComment);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getConfigFile() {
            return this.configFile;
        }

        public final void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        @Override
        public final Builder configFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        public final String getRepositoryLinkId() {
            return this.repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSyncType() {
            return this.syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        public final String getPublishDeploymentStatus() {
            return this.publishDeploymentStatus;
        }

        public final void setPublishDeploymentStatus(String publishDeploymentStatus) {
            this.publishDeploymentStatus = publishDeploymentStatus;
        }

        @Override
        public final Builder publishDeploymentStatus(String publishDeploymentStatus) {
            this.publishDeploymentStatus = publishDeploymentStatus;
            return this;
        }

        @Override
        public final Builder publishDeploymentStatus(PublishDeploymentStatus publishDeploymentStatus) {
            this.publishDeploymentStatus(publishDeploymentStatus == null ? null : publishDeploymentStatus.toString());
            return this;
        }

        public final String getTriggerResourceUpdateOn() {
            return this.triggerResourceUpdateOn;
        }

        public final void setTriggerResourceUpdateOn(String triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn = triggerResourceUpdateOn;
        }

        @Override
        public final Builder triggerResourceUpdateOn(String triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn = triggerResourceUpdateOn;
            return this;
        }

        @Override
        public final Builder triggerResourceUpdateOn(TriggerResourceUpdateOn triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn(triggerResourceUpdateOn == null ? null : triggerResourceUpdateOn.toString());
            return this;
        }

        public final String getPullRequestComment() {
            return this.pullRequestComment;
        }

        public final void setPullRequestComment(String pullRequestComment) {
            this.pullRequestComment = pullRequestComment;
        }

        @Override
        public final Builder pullRequestComment(String pullRequestComment) {
            this.pullRequestComment = pullRequestComment;
            return this;
        }

        @Override
        public final Builder pullRequestComment(PullRequestComment pullRequestComment) {
            this.pullRequestComment(pullRequestComment == null ? null : pullRequestComment.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSyncConfigurationRequest build() {
            return new CreateSyncConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeConnectionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSyncConfigurationRequest> {
        public Builder branch(String var1);

        public Builder configFile(String var1);

        public Builder repositoryLinkId(String var1);

        public Builder resourceName(String var1);

        public Builder roleArn(String var1);

        public Builder syncType(String var1);

        public Builder syncType(SyncConfigurationType var1);

        public Builder publishDeploymentStatus(String var1);

        public Builder publishDeploymentStatus(PublishDeploymentStatus var1);

        public Builder triggerResourceUpdateOn(String var1);

        public Builder triggerResourceUpdateOn(TriggerResourceUpdateOn var1);

        public Builder pullRequestComment(String var1);

        public Builder pullRequestComment(PullRequestComment var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

