/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A trigger failed to run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryTriggerExecutionFailure implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryTriggerExecutionFailure.Builder, RepositoryTriggerExecutionFailure> {
    private static final SdkField<String> TRIGGER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("trigger")
            .getter(getter(RepositoryTriggerExecutionFailure::trigger)).setter(setter(Builder::trigger))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trigger").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(RepositoryTriggerExecutionFailure::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_FIELD,
            FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trigger;

    private final String failureMessage;

    private RepositoryTriggerExecutionFailure(BuilderImpl builder) {
        this.trigger = builder.trigger;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The name of the trigger that did not run.
     * </p>
     * 
     * @return The name of the trigger that did not run.
     */
    public final String trigger() {
        return trigger;
    }

    /**
     * <p>
     * Message information about the trigger that did not run.
     * </p>
     * 
     * @return Message information about the trigger that did not run.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trigger());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryTriggerExecutionFailure)) {
            return false;
        }
        RepositoryTriggerExecutionFailure other = (RepositoryTriggerExecutionFailure) obj;
        return Objects.equals(trigger(), other.trigger()) && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryTriggerExecutionFailure").add("Trigger", trigger())
                .add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trigger":
            return Optional.ofNullable(clazz.cast(trigger()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trigger", TRIGGER_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryTriggerExecutionFailure, T> g) {
        return obj -> g.apply((RepositoryTriggerExecutionFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryTriggerExecutionFailure> {
        /**
         * <p>
         * The name of the trigger that did not run.
         * </p>
         * 
         * @param trigger
         *        The name of the trigger that did not run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trigger(String trigger);

        /**
         * <p>
         * Message information about the trigger that did not run.
         * </p>
         * 
         * @param failureMessage
         *        Message information about the trigger that did not run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String trigger;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryTriggerExecutionFailure model) {
            trigger(model.trigger);
            failureMessage(model.failureMessage);
        }

        public final String getTrigger() {
            return trigger;
        }

        public final void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        @Override
        public final Builder trigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public RepositoryTriggerExecutionFailure build() {
            return new RepositoryTriggerExecutionFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
