/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MergeOptionTypeEnum {
    FAST_FORWARD_MERGE("FAST_FORWARD_MERGE"),
    SQUASH_MERGE("SQUASH_MERGE"),
    THREE_WAY_MERGE("THREE_WAY_MERGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MergeOptionTypeEnum> VALUE_MAP;
    private final String value;

    private MergeOptionTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MergeOptionTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MergeOptionTypeEnum> knownValues() {
        EnumSet<MergeOptionTypeEnum> knownValues = EnumSet.allOf(MergeOptionTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MergeOptionTypeEnum.class, MergeOptionTypeEnum::toString);
    }
}

