/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClientBuilder;
import software.amazon.awssdk.services.codecommit.CodeCommitServiceClientConfiguration;
import software.amazon.awssdk.services.codecommit.DefaultCodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.DefaultCodeCommitBaseClientBuilder;
import software.amazon.awssdk.services.codecommit.endpoints.CodeCommitEndpointProvider;

@SdkInternalApi
final class DefaultCodeCommitAsyncClientBuilder
extends DefaultCodeCommitBaseClientBuilder<CodeCommitAsyncClientBuilder, CodeCommitAsyncClient>
implements CodeCommitAsyncClientBuilder {
    DefaultCodeCommitAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeCommitAsyncClientBuilder endpointProvider(CodeCommitEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeCommitAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeCommitAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeCommitServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeCommitAsyncClient client = new DefaultCodeCommitAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeCommitServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeCommitServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

