/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;

public class GetDifferencesIterable
implements SdkIterable<GetDifferencesResponse> {
    private final CodeCommitClient client;
    private final GetDifferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDifferencesIterable(CodeCommitClient client, GetDifferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDifferencesResponseFetcher();
    }

    public Iterator<GetDifferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDifferencesResponseFetcher
    implements SyncPageFetcher<GetDifferencesResponse> {
        private GetDifferencesResponseFetcher() {
        }

        public boolean hasNextPage(GetDifferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDifferencesResponse nextPage(GetDifferencesResponse previousPage) {
            if (previousPage == null) {
                return GetDifferencesIterable.this.client.getDifferences(GetDifferencesIterable.this.firstRequest);
            }
            return GetDifferencesIterable.this.client.getDifferences((GetDifferencesRequest)((Object)GetDifferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

