/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum;
import software.amazon.awssdk.services.codecommit.model.ConflictResolution;
import software.amazon.awssdk.services.codecommit.model.ConflictResolutionStrategyTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeBranchesByThreeWayRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, MergeBranchesByThreeWayRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::repositoryName)).setter(MergeBranchesByThreeWayRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::sourceCommitSpecifier)).setter(MergeBranchesByThreeWayRequest.setter(Builder::sourceCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::destinationCommitSpecifier)).setter(MergeBranchesByThreeWayRequest.setter(Builder::destinationCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build()}).build();
    private static final SdkField<String> TARGET_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::targetBranch)).setter(MergeBranchesByThreeWayRequest.setter(Builder::targetBranch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBranch").build()}).build();
    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::conflictDetailLevelAsString)).setter(MergeBranchesByThreeWayRequest.setter(Builder::conflictDetailLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build()}).build();
    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::conflictResolutionStrategyAsString)).setter(MergeBranchesByThreeWayRequest.setter(Builder::conflictResolutionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build()}).build();
    private static final SdkField<String> AUTHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::authorName)).setter(MergeBranchesByThreeWayRequest.setter(Builder::authorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorName").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::email)).setter(MergeBranchesByThreeWayRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::commitMessage)).setter(MergeBranchesByThreeWayRequest.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()}).build();
    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::keepEmptyFolders)).setter(MergeBranchesByThreeWayRequest.setter(Builder::keepEmptyFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()}).build();
    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MergeBranchesByThreeWayRequest.getter(MergeBranchesByThreeWayRequest::conflictResolution)).setter(MergeBranchesByThreeWayRequest.setter(Builder::conflictResolution)).constructor(ConflictResolution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, TARGET_BRANCH_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD, AUTHOR_NAME_FIELD, EMAIL_FIELD, COMMIT_MESSAGE_FIELD, KEEP_EMPTY_FOLDERS_FIELD, CONFLICT_RESOLUTION_FIELD));
    private final String repositoryName;
    private final String sourceCommitSpecifier;
    private final String destinationCommitSpecifier;
    private final String targetBranch;
    private final String conflictDetailLevel;
    private final String conflictResolutionStrategy;
    private final String authorName;
    private final String email;
    private final String commitMessage;
    private final Boolean keepEmptyFolders;
    private final ConflictResolution conflictResolution;

    private MergeBranchesByThreeWayRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.targetBranch = builder.targetBranch;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.authorName = builder.authorName;
        this.email = builder.email;
        this.commitMessage = builder.commitMessage;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.conflictResolution = builder.conflictResolution;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String sourceCommitSpecifier() {
        return this.sourceCommitSpecifier;
    }

    public String destinationCommitSpecifier() {
        return this.destinationCommitSpecifier;
    }

    public String targetBranch() {
        return this.targetBranch;
    }

    public ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(this.conflictDetailLevel);
    }

    public String conflictDetailLevelAsString() {
        return this.conflictDetailLevel;
    }

    public ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(this.conflictResolutionStrategy);
    }

    public String conflictResolutionStrategyAsString() {
        return this.conflictResolutionStrategy;
    }

    public String authorName() {
        return this.authorName;
    }

    public String email() {
        return this.email;
    }

    public String commitMessage() {
        return this.commitMessage;
    }

    public Boolean keepEmptyFolders() {
        return this.keepEmptyFolders;
    }

    public ConflictResolution conflictResolution() {
        return this.conflictResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBranch());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolution());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeBranchesByThreeWayRequest)) {
            return false;
        }
        MergeBranchesByThreeWayRequest other = (MergeBranchesByThreeWayRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceCommitSpecifier(), other.sourceCommitSpecifier()) && Objects.equals(this.destinationCommitSpecifier(), other.destinationCommitSpecifier()) && Objects.equals(this.targetBranch(), other.targetBranch()) && Objects.equals(this.conflictDetailLevelAsString(), other.conflictDetailLevelAsString()) && Objects.equals(this.conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString()) && Objects.equals(this.authorName(), other.authorName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.keepEmptyFolders(), other.keepEmptyFolders()) && Objects.equals(this.conflictResolution(), other.conflictResolution());
    }

    public String toString() {
        return ToString.builder((String)"MergeBranchesByThreeWayRequest").add("RepositoryName", (Object)this.repositoryName()).add("SourceCommitSpecifier", (Object)this.sourceCommitSpecifier()).add("DestinationCommitSpecifier", (Object)this.destinationCommitSpecifier()).add("TargetBranch", (Object)this.targetBranch()).add("ConflictDetailLevel", (Object)this.conflictDetailLevelAsString()).add("ConflictResolutionStrategy", (Object)this.conflictResolutionStrategyAsString()).add("AuthorName", (Object)this.authorName()).add("Email", (Object)this.email()).add("CommitMessage", (Object)this.commitMessage()).add("KeepEmptyFolders", (Object)this.keepEmptyFolders()).add("ConflictResolution", (Object)this.conflictResolution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitSpecifier()));
            }
            case "destinationCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitSpecifier()));
            }
            case "targetBranch": {
                return Optional.ofNullable(clazz.cast(this.targetBranch()));
            }
            case "conflictDetailLevel": {
                return Optional.ofNullable(clazz.cast(this.conflictDetailLevelAsString()));
            }
            case "conflictResolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.conflictResolutionStrategyAsString()));
            }
            case "authorName": {
                return Optional.ofNullable(clazz.cast(this.authorName()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "commitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "keepEmptyFolders": {
                return Optional.ofNullable(clazz.cast(this.keepEmptyFolders()));
            }
            case "conflictResolution": {
                return Optional.ofNullable(clazz.cast(this.conflictResolution()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeBranchesByThreeWayRequest, T> g) {
        return obj -> g.apply((MergeBranchesByThreeWayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceCommitSpecifier;
        private String destinationCommitSpecifier;
        private String targetBranch;
        private String conflictDetailLevel;
        private String conflictResolutionStrategy;
        private String authorName;
        private String email;
        private String commitMessage;
        private Boolean keepEmptyFolders;
        private ConflictResolution conflictResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeBranchesByThreeWayRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.sourceCommitSpecifier(model.sourceCommitSpecifier);
            this.destinationCommitSpecifier(model.destinationCommitSpecifier);
            this.targetBranch(model.targetBranch);
            this.conflictDetailLevel(model.conflictDetailLevel);
            this.conflictResolutionStrategy(model.conflictResolutionStrategy);
            this.authorName(model.authorName);
            this.email(model.email);
            this.commitMessage(model.commitMessage);
            this.keepEmptyFolders(model.keepEmptyFolders);
            this.conflictResolution(model.conflictResolution);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceCommitSpecifier() {
            return this.sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        public final String getDestinationCommitSpecifier() {
            return this.destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        public final String getTargetBranch() {
            return this.targetBranch;
        }

        @Override
        public final Builder targetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
            return this;
        }

        public final void setTargetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
        }

        public final String getConflictDetailLevel() {
            return this.conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        public final String getConflictResolutionStrategy() {
            return this.conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        public final String getAuthorName() {
            return this.authorName;
        }

        @Override
        public final Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public final void setAuthorName(String authorName) {
            this.authorName = authorName;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        public final Boolean getKeepEmptyFolders() {
            return this.keepEmptyFolders;
        }

        @Override
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return this.conflictResolution != null ? this.conflictResolution.toBuilder() : null;
        }

        @Override
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeBranchesByThreeWayRequest build() {
            return new MergeBranchesByThreeWayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergeBranchesByThreeWayRequest> {
        public Builder repositoryName(String var1);

        public Builder sourceCommitSpecifier(String var1);

        public Builder destinationCommitSpecifier(String var1);

        public Builder targetBranch(String var1);

        public Builder conflictDetailLevel(String var1);

        public Builder conflictDetailLevel(ConflictDetailLevelTypeEnum var1);

        public Builder conflictResolutionStrategy(String var1);

        public Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum var1);

        public Builder authorName(String var1);

        public Builder email(String var1);

        public Builder commitMessage(String var1);

        public Builder keepEmptyFolders(Boolean var1);

        public Builder conflictResolution(ConflictResolution var1);

        default public Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return this.conflictResolution((ConflictResolution)((ConflictResolution.Builder)ConflictResolution.builder().applyMutation(conflictResolution)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

