/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.FileModeTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class File
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, File> {
    private static final SdkField<String> BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(File.getter(File::blobId)).setter(File.setter(Builder::blobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()}).build();
    private static final SdkField<String> ABSOLUTE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(File.getter(File::absolutePath)).setter(File.setter(Builder::absolutePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolutePath").build()}).build();
    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(File.getter(File::relativePath)).setter(File.setter(Builder::relativePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativePath").build()}).build();
    private static final SdkField<String> FILE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(File.getter(File::fileModeAsString)).setter(File.setter(Builder::fileMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_ID_FIELD, ABSOLUTE_PATH_FIELD, RELATIVE_PATH_FIELD, FILE_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String blobId;
    private final String absolutePath;
    private final String relativePath;
    private final String fileMode;

    private File(BuilderImpl builder) {
        this.blobId = builder.blobId;
        this.absolutePath = builder.absolutePath;
        this.relativePath = builder.relativePath;
        this.fileMode = builder.fileMode;
    }

    public String blobId() {
        return this.blobId;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public String relativePath() {
        return this.relativePath;
    }

    public FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(this.fileMode);
    }

    public String fileModeAsString() {
        return this.fileMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.absolutePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof File)) {
            return false;
        }
        File other = (File)obj;
        return Objects.equals(this.blobId(), other.blobId()) && Objects.equals(this.absolutePath(), other.absolutePath()) && Objects.equals(this.relativePath(), other.relativePath()) && Objects.equals(this.fileModeAsString(), other.fileModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"File").add("BlobId", (Object)this.blobId()).add("AbsolutePath", (Object)this.absolutePath()).add("RelativePath", (Object)this.relativePath()).add("FileMode", (Object)this.fileModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blobId": {
                return Optional.ofNullable(clazz.cast(this.blobId()));
            }
            case "absolutePath": {
                return Optional.ofNullable(clazz.cast(this.absolutePath()));
            }
            case "relativePath": {
                return Optional.ofNullable(clazz.cast(this.relativePath()));
            }
            case "fileMode": {
                return Optional.ofNullable(clazz.cast(this.fileModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<File, T> g) {
        return obj -> g.apply((File)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blobId;
        private String absolutePath;
        private String relativePath;
        private String fileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(File model) {
            this.blobId(model.blobId);
            this.absolutePath(model.absolutePath);
            this.relativePath(model.relativePath);
            this.fileMode(model.fileMode);
        }

        public final String getBlobId() {
            return this.blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        public final String getAbsolutePath() {
            return this.absolutePath;
        }

        @Override
        public final Builder absolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
            return this;
        }

        public final void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public final String getRelativePath() {
            return this.relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        public final String getFileMode() {
            return this.fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        public File build() {
            return new File(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, File> {
        public Builder blobId(String var1);

        public Builder absolutePath(String var1);

        public Builder relativePath(String var1);

        public Builder fileMode(String var1);

        public Builder fileMode(FileModeTypeEnum var1);
    }
}

