/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum;
import software.amazon.awssdk.services.codecommit.model.ConflictResolutionStrategyTypeEnum;
import software.amazon.awssdk.services.codecommit.model.FilePathsCopier;
import software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeMergeConflictsRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, BatchDescribeMergeConflictsRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::repositoryName)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::destinationCommitSpecifier)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::destinationCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::sourceCommitSpecifier)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::sourceCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build()}).build();
    private static final SdkField<String> MERGE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::mergeOptionAsString)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::mergeOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOption").build()}).build();
    private static final SdkField<Integer> MAX_MERGE_HUNKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::maxMergeHunks)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::maxMergeHunks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMergeHunks").build()}).build();
    private static final SdkField<Integer> MAX_CONFLICT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::maxConflictFiles)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::maxConflictFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConflictFiles").build()}).build();
    private static final SdkField<List<String>> FILE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::filePaths)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::filePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::conflictDetailLevelAsString)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::conflictDetailLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build()}).build();
    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::conflictResolutionStrategyAsString)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::conflictResolutionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDescribeMergeConflictsRequest.getter(BatchDescribeMergeConflictsRequest::nextToken)).setter(BatchDescribeMergeConflictsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, MERGE_OPTION_FIELD, MAX_MERGE_HUNKS_FIELD, MAX_CONFLICT_FILES_FIELD, FILE_PATHS_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD, NEXT_TOKEN_FIELD));
    private final String repositoryName;
    private final String destinationCommitSpecifier;
    private final String sourceCommitSpecifier;
    private final String mergeOption;
    private final Integer maxMergeHunks;
    private final Integer maxConflictFiles;
    private final List<String> filePaths;
    private final String conflictDetailLevel;
    private final String conflictResolutionStrategy;
    private final String nextToken;

    private BatchDescribeMergeConflictsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.mergeOption = builder.mergeOption;
        this.maxMergeHunks = builder.maxMergeHunks;
        this.maxConflictFiles = builder.maxConflictFiles;
        this.filePaths = builder.filePaths;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.nextToken = builder.nextToken;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String destinationCommitSpecifier() {
        return this.destinationCommitSpecifier;
    }

    public String sourceCommitSpecifier() {
        return this.sourceCommitSpecifier;
    }

    public MergeOptionTypeEnum mergeOption() {
        return MergeOptionTypeEnum.fromValue(this.mergeOption);
    }

    public String mergeOptionAsString() {
        return this.mergeOption;
    }

    public Integer maxMergeHunks() {
        return this.maxMergeHunks;
    }

    public Integer maxConflictFiles() {
        return this.maxConflictFiles;
    }

    public boolean hasFilePaths() {
        return this.filePaths != null && !(this.filePaths instanceof SdkAutoConstructList);
    }

    public List<String> filePaths() {
        return this.filePaths;
    }

    public ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(this.conflictDetailLevel);
    }

    public String conflictDetailLevelAsString() {
        return this.conflictDetailLevel;
    }

    public ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(this.conflictResolutionStrategy);
    }

    public String conflictResolutionStrategyAsString() {
        return this.conflictResolutionStrategy;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMergeHunks());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConflictFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeMergeConflictsRequest)) {
            return false;
        }
        BatchDescribeMergeConflictsRequest other = (BatchDescribeMergeConflictsRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.destinationCommitSpecifier(), other.destinationCommitSpecifier()) && Objects.equals(this.sourceCommitSpecifier(), other.sourceCommitSpecifier()) && Objects.equals(this.mergeOptionAsString(), other.mergeOptionAsString()) && Objects.equals(this.maxMergeHunks(), other.maxMergeHunks()) && Objects.equals(this.maxConflictFiles(), other.maxConflictFiles()) && Objects.equals(this.filePaths(), other.filePaths()) && Objects.equals(this.conflictDetailLevelAsString(), other.conflictDetailLevelAsString()) && Objects.equals(this.conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchDescribeMergeConflictsRequest").add("RepositoryName", (Object)this.repositoryName()).add("DestinationCommitSpecifier", (Object)this.destinationCommitSpecifier()).add("SourceCommitSpecifier", (Object)this.sourceCommitSpecifier()).add("MergeOption", (Object)this.mergeOptionAsString()).add("MaxMergeHunks", (Object)this.maxMergeHunks()).add("MaxConflictFiles", (Object)this.maxConflictFiles()).add("FilePaths", this.filePaths()).add("ConflictDetailLevel", (Object)this.conflictDetailLevelAsString()).add("ConflictResolutionStrategy", (Object)this.conflictResolutionStrategyAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "destinationCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitSpecifier()));
            }
            case "sourceCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitSpecifier()));
            }
            case "mergeOption": {
                return Optional.ofNullable(clazz.cast(this.mergeOptionAsString()));
            }
            case "maxMergeHunks": {
                return Optional.ofNullable(clazz.cast(this.maxMergeHunks()));
            }
            case "maxConflictFiles": {
                return Optional.ofNullable(clazz.cast(this.maxConflictFiles()));
            }
            case "filePaths": {
                return Optional.ofNullable(clazz.cast(this.filePaths()));
            }
            case "conflictDetailLevel": {
                return Optional.ofNullable(clazz.cast(this.conflictDetailLevelAsString()));
            }
            case "conflictResolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.conflictResolutionStrategyAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeMergeConflictsRequest, T> g) {
        return obj -> g.apply((BatchDescribeMergeConflictsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String destinationCommitSpecifier;
        private String sourceCommitSpecifier;
        private String mergeOption;
        private Integer maxMergeHunks;
        private Integer maxConflictFiles;
        private List<String> filePaths = DefaultSdkAutoConstructList.getInstance();
        private String conflictDetailLevel;
        private String conflictResolutionStrategy;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeMergeConflictsRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.destinationCommitSpecifier(model.destinationCommitSpecifier);
            this.sourceCommitSpecifier(model.sourceCommitSpecifier);
            this.mergeOption(model.mergeOption);
            this.maxMergeHunks(model.maxMergeHunks);
            this.maxConflictFiles(model.maxConflictFiles);
            this.filePaths(model.filePaths);
            this.conflictDetailLevel(model.conflictDetailLevel);
            this.conflictResolutionStrategy(model.conflictResolutionStrategy);
            this.nextToken(model.nextToken);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getDestinationCommitSpecifier() {
            return this.destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        public final String getSourceCommitSpecifier() {
            return this.sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        public final String getMergeOption() {
            return this.mergeOption;
        }

        @Override
        public final Builder mergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
            return this;
        }

        @Override
        public final Builder mergeOption(MergeOptionTypeEnum mergeOption) {
            this.mergeOption(mergeOption == null ? null : mergeOption.toString());
            return this;
        }

        public final void setMergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
        }

        public final Integer getMaxMergeHunks() {
            return this.maxMergeHunks;
        }

        @Override
        public final Builder maxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
            return this;
        }

        public final void setMaxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
        }

        public final Integer getMaxConflictFiles() {
            return this.maxConflictFiles;
        }

        @Override
        public final Builder maxConflictFiles(Integer maxConflictFiles) {
            this.maxConflictFiles = maxConflictFiles;
            return this;
        }

        public final void setMaxConflictFiles(Integer maxConflictFiles) {
            this.maxConflictFiles = maxConflictFiles;
        }

        public final Collection<String> getFilePaths() {
            return this.filePaths;
        }

        @Override
        public final Builder filePaths(Collection<String> filePaths) {
            this.filePaths = FilePathsCopier.copy(filePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(String ... filePaths) {
            this.filePaths(Arrays.asList(filePaths));
            return this;
        }

        public final void setFilePaths(Collection<String> filePaths) {
            this.filePaths = FilePathsCopier.copy(filePaths);
        }

        public final String getConflictDetailLevel() {
            return this.conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        public final String getConflictResolutionStrategy() {
            return this.conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDescribeMergeConflictsRequest build() {
            return new BatchDescribeMergeConflictsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeMergeConflictsRequest> {
        public Builder repositoryName(String var1);

        public Builder destinationCommitSpecifier(String var1);

        public Builder sourceCommitSpecifier(String var1);

        public Builder mergeOption(String var1);

        public Builder mergeOption(MergeOptionTypeEnum var1);

        public Builder maxMergeHunks(Integer var1);

        public Builder maxConflictFiles(Integer var1);

        public Builder filePaths(Collection<String> var1);

        public Builder filePaths(String ... var1);

        public Builder conflictDetailLevel(String var1);

        public Builder conflictDetailLevel(ConflictDetailLevelTypeEnum var1);

        public Builder conflictResolutionStrategy(String var1);

        public Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

