/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverridePullRequestApprovalRulesRequest extends CodeCommitRequest implements
        ToCopyableBuilder<OverridePullRequestApprovalRulesRequest.Builder, OverridePullRequestApprovalRulesRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OverridePullRequestApprovalRulesRequest::pullRequestId)).setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OverridePullRequestApprovalRulesRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> OVERRIDE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OverridePullRequestApprovalRulesRequest::overrideStatusAsString))
            .setter(setter(Builder::overrideStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            REVISION_ID_FIELD, OVERRIDE_STATUS_FIELD));

    private final String pullRequestId;

    private final String revisionId;

    private final String overrideStatus;

    private OverridePullRequestApprovalRulesRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.revisionId = builder.revisionId;
        this.overrideStatus = builder.overrideStatus;
    }

    /**
     * <p>
     * The system-generated ID of the pull request for which you want to override all approval rule requirements. To get
     * this information, use <a>GetPullRequest</a>.
     * </p>
     * 
     * @return The system-generated ID of the pull request for which you want to override all approval rule
     *         requirements. To get this information, use <a>GetPullRequest</a>.
     */
    public String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for
     * anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.
     * </p>
     * 
     * @return The system-generated ID of the most recent revision of the pull request. You cannot override approval
     *         rules for anything but the most recent revision of a pull request. To get the revision ID, use
     *         GetPullRequest.
     */
    public String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous
     * override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideStatus}
     * will return {@link OverrideStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overrideStatusAsString}.
     * </p>
     * 
     * @return Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a
     *         previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
     * @see OverrideStatus
     */
    public OverrideStatus overrideStatus() {
        return OverrideStatus.fromValue(overrideStatus);
    }

    /**
     * <p>
     * Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous
     * override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideStatus}
     * will return {@link OverrideStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overrideStatusAsString}.
     * </p>
     * 
     * @return Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a
     *         previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
     * @see OverrideStatus
     */
    public String overrideStatusAsString() {
        return overrideStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(overrideStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverridePullRequestApprovalRulesRequest)) {
            return false;
        }
        OverridePullRequestApprovalRulesRequest other = (OverridePullRequestApprovalRulesRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(overrideStatusAsString(), other.overrideStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OverridePullRequestApprovalRulesRequest").add("PullRequestId", pullRequestId())
                .add("RevisionId", revisionId()).add("OverrideStatus", overrideStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "overrideStatus":
            return Optional.ofNullable(clazz.cast(overrideStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OverridePullRequestApprovalRulesRequest, T> g) {
        return obj -> g.apply((OverridePullRequestApprovalRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, OverridePullRequestApprovalRulesRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request for which you want to override all approval rule requirements. To
         * get this information, use <a>GetPullRequest</a>.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request for which you want to override all approval rule
         *        requirements. To get this information, use <a>GetPullRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The system-generated ID of the most recent revision of the pull request. You cannot override approval rules
         * for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.
         * </p>
         * 
         * @param revisionId
         *        The system-generated ID of the most recent revision of the pull request. You cannot override approval
         *        rules for anything but the most recent revision of a pull request. To get the revision ID, use
         *        GetPullRequest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous
         * override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
         * </p>
         * 
         * @param overrideStatus
         *        Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a
         *        previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
         * @see OverrideStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideStatus
         */
        Builder overrideStatus(String overrideStatus);

        /**
         * <p>
         * Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous
         * override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
         * </p>
         * 
         * @param overrideStatus
         *        Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a
         *        previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.
         * @see OverrideStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideStatus
         */
        Builder overrideStatus(OverrideStatus overrideStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String revisionId;

        private String overrideStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(OverridePullRequestApprovalRulesRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            revisionId(model.revisionId);
            overrideStatus(model.overrideStatus);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getOverrideStatus() {
            return overrideStatus;
        }

        @Override
        public final Builder overrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
            return this;
        }

        @Override
        public final Builder overrideStatus(OverrideStatus overrideStatus) {
            this.overrideStatus(overrideStatus == null ? null : overrideStatus.toString());
            return this;
        }

        public final void setOverrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OverridePullRequestApprovalRulesRequest build() {
            return new OverridePullRequestApprovalRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
