/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFileResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetFileResponse.Builder, GetFileResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFileResponse::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFileResponse::blobId)).setter(setter(Builder::blobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFileResponse::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> FILE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFileResponse::fileModeAsString)).setter(setter(Builder::fileMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetFileResponse::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()).build();

    private static final SdkField<SdkBytes> FILE_CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(GetFileResponse::fileContent)).setter(setter(Builder::fileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD,
            BLOB_ID_FIELD, FILE_PATH_FIELD, FILE_MODE_FIELD, FILE_SIZE_FIELD, FILE_CONTENT_FIELD));

    private final String commitId;

    private final String blobId;

    private final String filePath;

    private final String fileMode;

    private final Long fileSize;

    private final SdkBytes fileContent;

    private GetFileResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.blobId = builder.blobId;
        this.filePath = builder.filePath;
        this.fileMode = builder.fileMode;
        this.fileSize = builder.fileSize;
        this.fileContent = builder.fileContent;
    }

    /**
     * <p>
     * The full commit ID of the commit that contains the content returned by GetFile.
     * </p>
     * 
     * @return The full commit ID of the commit that contains the content returned by GetFile.
     */
    public String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The blob ID of the object that represents the file content.
     * </p>
     * 
     * @return The blob ID of the object that represents the file content.
     */
    public String blobId() {
        return blobId;
    }

    /**
     * <p>
     * The fully qualified path to the specified file. Returns the name and extension of the file.
     * </p>
     * 
     * @return The fully qualified path to the specified file. Returns the name and extension of the file.
     */
    public String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not
     * numeric values.
     * </p>
     * <note>
     * <p>
     * The file mode permissions returned by this API are not the standard file mode permission values, such as 100644,
     * but rather extrapolated values. See the supported return values.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and
     *         not numeric values.</p> <note>
     *         <p>
     *         The file mode permissions returned by this API are not the standard file mode permission values, such as
     *         100644, but rather extrapolated values. See the supported return values.
     *         </p>
     * @see FileModeTypeEnum
     */
    public FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(fileMode);
    }

    /**
     * <p>
     * The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not
     * numeric values.
     * </p>
     * <note>
     * <p>
     * The file mode permissions returned by this API are not the standard file mode permission values, such as 100644,
     * but rather extrapolated values. See the supported return values.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and
     *         not numeric values.</p> <note>
     *         <p>
     *         The file mode permissions returned by this API are not the standard file mode permission values, such as
     *         100644, but rather extrapolated values. See the supported return values.
     *         </p>
     * @see FileModeTypeEnum
     */
    public String fileModeAsString() {
        return fileMode;
    }

    /**
     * <p>
     * The size of the contents of the file, in bytes.
     * </p>
     * 
     * @return The size of the contents of the file, in bytes.
     */
    public Long fileSize() {
        return fileSize;
    }

    /**
     * <p>
     * The base-64 encoded binary data object that represents the content of the file.
     * </p>
     * 
     * @return The base-64 encoded binary data object that represents the content of the file.
     */
    public SdkBytes fileContent() {
        return fileContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(blobId());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(fileModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(fileContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFileResponse)) {
            return false;
        }
        GetFileResponse other = (GetFileResponse) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(blobId(), other.blobId())
                && Objects.equals(filePath(), other.filePath()) && Objects.equals(fileModeAsString(), other.fileModeAsString())
                && Objects.equals(fileSize(), other.fileSize()) && Objects.equals(fileContent(), other.fileContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetFileResponse").add("CommitId", commitId()).add("BlobId", blobId())
                .add("FilePath", filePath()).add("FileMode", fileModeAsString()).add("FileSize", fileSize())
                .add("FileContent", fileContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "blobId":
            return Optional.ofNullable(clazz.cast(blobId()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "fileMode":
            return Optional.ofNullable(clazz.cast(fileModeAsString()));
        case "fileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        case "fileContent":
            return Optional.ofNullable(clazz.cast(fileContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFileResponse, T> g) {
        return obj -> g.apply((GetFileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFileResponse> {
        /**
         * <p>
         * The full commit ID of the commit that contains the content returned by GetFile.
         * </p>
         * 
         * @param commitId
         *        The full commit ID of the commit that contains the content returned by GetFile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The blob ID of the object that represents the file content.
         * </p>
         * 
         * @param blobId
         *        The blob ID of the object that represents the file content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobId(String blobId);

        /**
         * <p>
         * The fully qualified path to the specified file. Returns the name and extension of the file.
         * </p>
         * 
         * @param filePath
         *        The fully qualified path to the specified file. Returns the name and extension of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not
         * numeric values.
         * </p>
         * <note>
         * <p>
         * The file mode permissions returned by this API are not the standard file mode permission values, such as
         * 100644, but rather extrapolated values. See the supported return values.
         * </p>
         * </note>
         * 
         * @param fileMode
         *        The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE
         *        and not numeric values.</p> <note>
         *        <p>
         *        The file mode permissions returned by this API are not the standard file mode permission values, such
         *        as 100644, but rather extrapolated values. See the supported return values.
         *        </p>
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(String fileMode);

        /**
         * <p>
         * The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not
         * numeric values.
         * </p>
         * <note>
         * <p>
         * The file mode permissions returned by this API are not the standard file mode permission values, such as
         * 100644, but rather extrapolated values. See the supported return values.
         * </p>
         * </note>
         * 
         * @param fileMode
         *        The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE
         *        and not numeric values.</p> <note>
         *        <p>
         *        The file mode permissions returned by this API are not the standard file mode permission values, such
         *        as 100644, but rather extrapolated values. See the supported return values.
         *        </p>
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(FileModeTypeEnum fileMode);

        /**
         * <p>
         * The size of the contents of the file, in bytes.
         * </p>
         * 
         * @param fileSize
         *        The size of the contents of the file, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);

        /**
         * <p>
         * The base-64 encoded binary data object that represents the content of the file.
         * </p>
         * 
         * @param fileContent
         *        The base-64 encoded binary data object that represents the content of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileContent(SdkBytes fileContent);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String commitId;

        private String blobId;

        private String filePath;

        private String fileMode;

        private Long fileSize;

        private SdkBytes fileContent;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFileResponse model) {
            super(model);
            commitId(model.commitId);
            blobId(model.blobId);
            filePath(model.filePath);
            fileMode(model.fileMode);
            fileSize(model.fileSize);
            fileContent(model.fileContent);
        }

        public final String getCommitId() {
            return commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getBlobId() {
            return blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        public final String getFilePath() {
            return filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public final String getFileMode() {
            return fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public final ByteBuffer getFileContent() {
            return fileContent == null ? null : fileContent.asByteBuffer();
        }

        @Override
        public final Builder fileContent(SdkBytes fileContent) {
            this.fileContent = StandardMemberCopier.copy(fileContent);
            return this;
        }

        public final void setFileContent(ByteBuffer fileContent) {
            fileContent(fileContent == null ? null : SdkBytes.fromByteBuffer(fileContent));
        }

        @Override
        public GetFileResponse build() {
            return new GetFileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
