/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDifferencesRequest extends CodeCommitRequest implements
        ToCopyableBuilder<GetDifferencesRequest.Builder, GetDifferencesRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDifferencesRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BEFORE_COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDifferencesRequest::beforeCommitSpecifier)).setter(setter(Builder::beforeCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitSpecifier").build())
            .build();

    private static final SdkField<String> AFTER_COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDifferencesRequest::afterCommitSpecifier)).setter(setter(Builder::afterCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitSpecifier").build())
            .build();

    private static final SdkField<String> BEFORE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDifferencesRequest::beforePath)).setter(setter(Builder::beforePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforePath").build()).build();

    private static final SdkField<String> AFTER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDifferencesRequest::afterPath)).setter(setter(Builder::afterPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterPath").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetDifferencesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDifferencesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            BEFORE_COMMIT_SPECIFIER_FIELD, AFTER_COMMIT_SPECIFIER_FIELD, BEFORE_PATH_FIELD, AFTER_PATH_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final String repositoryName;

    private final String beforeCommitSpecifier;

    private final String afterCommitSpecifier;

    private final String beforePath;

    private final String afterPath;

    private final Integer maxResults;

    private final String nextToken;

    private GetDifferencesRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.beforeCommitSpecifier = builder.beforeCommitSpecifier;
        this.afterCommitSpecifier = builder.afterCommitSpecifier;
        this.beforePath = builder.beforePath;
        this.afterPath = builder.afterPath;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the repository where you want to get differences.
     * </p>
     * 
     * @return The name of the repository where you want to get differences.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit
     * ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you
     * do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with
     * <code>maxResults</code>.
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the
     *         full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code>
     *         value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting
     *         the results with <code>maxResults</code>.
     */
    public String beforeCommitSpecifier() {
        return beforeCommitSpecifier;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit.
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit.
     */
    public String afterCommitSpecifier() {
        return afterCommitSpecifier;
    }

    /**
     * <p>
     * The file path in which to check for differences. Limits the results to this path. Can also be used to specify the
     * previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified,
     * differences are shown for all paths.
     * </p>
     * 
     * @return The file path in which to check for differences. Limits the results to this path. Can also be used to
     *         specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code>
     *         are not specified, differences are shown for all paths.
     */
    public String beforePath() {
        return beforePath;
    }

    /**
     * <p>
     * The file path in which to check differences. Limits the results to this path. Can also be used to specify the
     * changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.
     * </p>
     * 
     * @return The file path in which to check differences. Limits the results to this path. Can also be used to specify
     *         the changed name of a directory or folder, if it has changed. If not specified, differences are shown for
     *         all paths.
     */
    public String afterPath() {
        return afterPath;
    }

    /**
     * <p>
     * A non-zero, non-negative integer used to limit the number of returned results.
     * </p>
     * 
     * @return A non-zero, non-negative integer used to limit the number of returned results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(afterCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(beforePath());
        hashCode = 31 * hashCode + Objects.hashCode(afterPath());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDifferencesRequest)) {
            return false;
        }
        GetDifferencesRequest other = (GetDifferencesRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(beforeCommitSpecifier(), other.beforeCommitSpecifier())
                && Objects.equals(afterCommitSpecifier(), other.afterCommitSpecifier())
                && Objects.equals(beforePath(), other.beforePath()) && Objects.equals(afterPath(), other.afterPath())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDifferencesRequest").add("RepositoryName", repositoryName())
                .add("BeforeCommitSpecifier", beforeCommitSpecifier()).add("AfterCommitSpecifier", afterCommitSpecifier())
                .add("BeforePath", beforePath()).add("AfterPath", afterPath()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "beforeCommitSpecifier":
            return Optional.ofNullable(clazz.cast(beforeCommitSpecifier()));
        case "afterCommitSpecifier":
            return Optional.ofNullable(clazz.cast(afterCommitSpecifier()));
        case "beforePath":
            return Optional.ofNullable(clazz.cast(beforePath()));
        case "afterPath":
            return Optional.ofNullable(clazz.cast(afterPath()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDifferencesRequest, T> g) {
        return obj -> g.apply((GetDifferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDifferencesRequest> {
        /**
         * <p>
         * The name of the repository where you want to get differences.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where you want to get differences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full
         * commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are
         * shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results
         * with <code>maxResults</code>.
         * </p>
         * 
         * @param beforeCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the
         *        full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code>
         *        value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider
         *        limiting the results with <code>maxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCommitSpecifier(String beforeCommitSpecifier);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit.
         * </p>
         * 
         * @param afterCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCommitSpecifier(String afterCommitSpecifier);

        /**
         * <p>
         * The file path in which to check for differences. Limits the results to this path. Can also be used to specify
         * the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not
         * specified, differences are shown for all paths.
         * </p>
         * 
         * @param beforePath
         *        The file path in which to check for differences. Limits the results to this path. Can also be used to
         *        specify the previous name of a directory or folder. If <code>beforePath</code> and
         *        <code>afterPath</code> are not specified, differences are shown for all paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforePath(String beforePath);

        /**
         * <p>
         * The file path in which to check differences. Limits the results to this path. Can also be used to specify the
         * changed name of a directory or folder, if it has changed. If not specified, differences are shown for all
         * paths.
         * </p>
         * 
         * @param afterPath
         *        The file path in which to check differences. Limits the results to this path. Can also be used to
         *        specify the changed name of a directory or folder, if it has changed. If not specified, differences
         *        are shown for all paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterPath(String afterPath);

        /**
         * <p>
         * A non-zero, non-negative integer used to limit the number of returned results.
         * </p>
         * 
         * @param maxResults
         *        A non-zero, non-negative integer used to limit the number of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String beforeCommitSpecifier;

        private String afterCommitSpecifier;

        private String beforePath;

        private String afterPath;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDifferencesRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            beforeCommitSpecifier(model.beforeCommitSpecifier);
            afterCommitSpecifier(model.afterCommitSpecifier);
            beforePath(model.beforePath);
            afterPath(model.afterPath);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBeforeCommitSpecifier() {
            return beforeCommitSpecifier;
        }

        @Override
        public final Builder beforeCommitSpecifier(String beforeCommitSpecifier) {
            this.beforeCommitSpecifier = beforeCommitSpecifier;
            return this;
        }

        public final void setBeforeCommitSpecifier(String beforeCommitSpecifier) {
            this.beforeCommitSpecifier = beforeCommitSpecifier;
        }

        public final String getAfterCommitSpecifier() {
            return afterCommitSpecifier;
        }

        @Override
        public final Builder afterCommitSpecifier(String afterCommitSpecifier) {
            this.afterCommitSpecifier = afterCommitSpecifier;
            return this;
        }

        public final void setAfterCommitSpecifier(String afterCommitSpecifier) {
            this.afterCommitSpecifier = afterCommitSpecifier;
        }

        public final String getBeforePath() {
            return beforePath;
        }

        @Override
        public final Builder beforePath(String beforePath) {
            this.beforePath = beforePath;
            return this;
        }

        public final void setBeforePath(String beforePath) {
            this.beforePath = beforePath;
        }

        public final String getAfterPath() {
            return afterPath;
        }

        @Override
        public final Builder afterPath(String afterPath) {
            this.afterPath = afterPath;
            return this;
        }

        public final void setAfterPath(String afterPath) {
            this.afterPath = afterPath;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDifferencesRequest build() {
            return new GetDifferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
