/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the template that created the approval rule for a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginApprovalRuleTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginApprovalRuleTemplate.Builder, OriginApprovalRuleTemplate> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OriginApprovalRuleTemplate::approvalRuleTemplateId)).setter(setter(Builder::approvalRuleTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateId").build())
            .build();

    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OriginApprovalRuleTemplate::approvalRuleTemplateName))
            .setter(setter(Builder::approvalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROVAL_RULE_TEMPLATE_ID_FIELD, APPROVAL_RULE_TEMPLATE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String approvalRuleTemplateId;

    private final String approvalRuleTemplateName;

    private OriginApprovalRuleTemplate(BuilderImpl builder) {
        this.approvalRuleTemplateId = builder.approvalRuleTemplateId;
        this.approvalRuleTemplateName = builder.approvalRuleTemplateName;
    }

    /**
     * <p>
     * The ID of the template that created the approval rule.
     * </p>
     * 
     * @return The ID of the template that created the approval rule.
     */
    public String approvalRuleTemplateId() {
        return approvalRuleTemplateId;
    }

    /**
     * <p>
     * The name of the template that created the approval rule.
     * </p>
     * 
     * @return The name of the template that created the approval rule.
     */
    public String approvalRuleTemplateName() {
        return approvalRuleTemplateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginApprovalRuleTemplate)) {
            return false;
        }
        OriginApprovalRuleTemplate other = (OriginApprovalRuleTemplate) obj;
        return Objects.equals(approvalRuleTemplateId(), other.approvalRuleTemplateId())
                && Objects.equals(approvalRuleTemplateName(), other.approvalRuleTemplateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OriginApprovalRuleTemplate").add("ApprovalRuleTemplateId", approvalRuleTemplateId())
                .add("ApprovalRuleTemplateName", approvalRuleTemplateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateId":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateId()));
        case "approvalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginApprovalRuleTemplate, T> g) {
        return obj -> g.apply((OriginApprovalRuleTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginApprovalRuleTemplate> {
        /**
         * <p>
         * The ID of the template that created the approval rule.
         * </p>
         * 
         * @param approvalRuleTemplateId
         *        The ID of the template that created the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateId(String approvalRuleTemplateId);

        /**
         * <p>
         * The name of the template that created the approval rule.
         * </p>
         * 
         * @param approvalRuleTemplateName
         *        The name of the template that created the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateName(String approvalRuleTemplateName);
    }

    static final class BuilderImpl implements Builder {
        private String approvalRuleTemplateId;

        private String approvalRuleTemplateName;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginApprovalRuleTemplate model) {
            approvalRuleTemplateId(model.approvalRuleTemplateId);
            approvalRuleTemplateName(model.approvalRuleTemplateName);
        }

        public final String getApprovalRuleTemplateId() {
            return approvalRuleTemplateId;
        }

        @Override
        public final Builder approvalRuleTemplateId(String approvalRuleTemplateId) {
            this.approvalRuleTemplateId = approvalRuleTemplateId;
            return this;
        }

        public final void setApprovalRuleTemplateId(String approvalRuleTemplateId) {
            this.approvalRuleTemplateId = approvalRuleTemplateId;
        }

        public final String getApprovalRuleTemplateName() {
            return approvalRuleTemplateName;
        }

        @Override
        public final Builder approvalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
            return this;
        }

        public final void setApprovalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
        }

        @Override
        public OriginApprovalRuleTemplate build() {
            return new OriginApprovalRuleTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
