/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about whether a file is binary or textual in a merge or pull request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsBinaryFile implements SdkPojo, Serializable, ToCopyableBuilder<IsBinaryFile.Builder, IsBinaryFile> {
    private static final SdkField<Boolean> SOURCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(IsBinaryFile::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Boolean> DESTINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(IsBinaryFile::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<Boolean> BASE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(IsBinaryFile::base)).setter(setter(Builder::base))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("base").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, BASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean source;

    private final Boolean destination;

    private final Boolean base;

    private IsBinaryFile(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.base = builder.base;
    }

    /**
     * <p>
     * The binary or non-binary status of file in the source of a merge or pull request.
     * </p>
     * 
     * @return The binary or non-binary status of file in the source of a merge or pull request.
     */
    public Boolean source() {
        return source;
    }

    /**
     * <p>
     * The binary or non-binary status of a file in the destination of a merge or pull request.
     * </p>
     * 
     * @return The binary or non-binary status of a file in the destination of a merge or pull request.
     */
    public Boolean destination() {
        return destination;
    }

    /**
     * <p>
     * The binary or non-binary status of a file in the base of a merge or pull request.
     * </p>
     * 
     * @return The binary or non-binary status of a file in the base of a merge or pull request.
     */
    public Boolean base() {
        return base;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(base());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsBinaryFile)) {
            return false;
        }
        IsBinaryFile other = (IsBinaryFile) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && Objects.equals(base(), other.base());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IsBinaryFile").add("Source", source()).add("Destination", destination()).add("Base", base())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "base":
            return Optional.ofNullable(clazz.cast(base()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IsBinaryFile, T> g) {
        return obj -> g.apply((IsBinaryFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IsBinaryFile> {
        /**
         * <p>
         * The binary or non-binary status of file in the source of a merge or pull request.
         * </p>
         * 
         * @param source
         *        The binary or non-binary status of file in the source of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Boolean source);

        /**
         * <p>
         * The binary or non-binary status of a file in the destination of a merge or pull request.
         * </p>
         * 
         * @param destination
         *        The binary or non-binary status of a file in the destination of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Boolean destination);

        /**
         * <p>
         * The binary or non-binary status of a file in the base of a merge or pull request.
         * </p>
         * 
         * @param base
         *        The binary or non-binary status of a file in the base of a merge or pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base(Boolean base);
    }

    static final class BuilderImpl implements Builder {
        private Boolean source;

        private Boolean destination;

        private Boolean base;

        private BuilderImpl() {
        }

        private BuilderImpl(IsBinaryFile model) {
            source(model.source);
            destination(model.destination);
            base(model.base);
        }

        public final Boolean getSource() {
            return source;
        }

        @Override
        public final Builder source(Boolean source) {
            this.source = source;
            return this;
        }

        public final void setSource(Boolean source) {
            this.source = source;
        }

        public final Boolean getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(Boolean destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Boolean destination) {
            this.destination = destination;
        }

        public final Boolean getBase() {
            return base;
        }

        @Override
        public final Builder base(Boolean base) {
            this.base = base;
            return this;
        }

        public final void setBase(Boolean base) {
            this.base = base;
        }

        @Override
        public IsBinaryFile build() {
            return new IsBinaryFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
