/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest extends CodeCommitRequest
        implements
        ToCopyableBuilder<BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest.Builder, BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest::approvalRuleTemplateName))
            .setter(setter(Builder::approvalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateName").build())
            .build();

    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest::repositoryNames))
            .setter(setter(Builder::repositoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROVAL_RULE_TEMPLATE_NAME_FIELD, REPOSITORY_NAMES_FIELD));

    private final String approvalRuleTemplateName;

    private final List<String> repositoryNames;

    private BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateName = builder.approvalRuleTemplateName;
        this.repositoryNames = builder.repositoryNames;
    }

    /**
     * <p>
     * The name of the template that you want to disassociate from one or more repositories.
     * </p>
     * 
     * @return The name of the template that you want to disassociate from one or more repositories.
     */
    public String approvalRuleTemplateName() {
        return approvalRuleTemplateName;
    }

    /**
     * Returns true if the RepositoryNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRepositoryNames() {
        return repositoryNames != null && !(repositoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository names that you want to disassociate from the approval rule template.
     * </p>
     * <note>
     * <p>
     * The length constraint limit is for each string in the array. The array itself can be empty.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRepositoryNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The repository names that you want to disassociate from the approval rule template.</p> <note>
     *         <p>
     *         The length constraint limit is for each string in the array. The array itself can be empty.
     *         </p>
     */
    public List<String> repositoryNames() {
        return repositoryNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest)) {
            return false;
        }
        BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest other = (BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest) obj;
        return Objects.equals(approvalRuleTemplateName(), other.approvalRuleTemplateName())
                && Objects.equals(repositoryNames(), other.repositoryNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest")
                .add("ApprovalRuleTemplateName", approvalRuleTemplateName()).add("RepositoryNames", repositoryNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateName()));
        case "repositoryNames":
            return Optional.ofNullable(clazz.cast(repositoryNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest, T> g) {
        return obj -> g.apply((BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest> {
        /**
         * <p>
         * The name of the template that you want to disassociate from one or more repositories.
         * </p>
         * 
         * @param approvalRuleTemplateName
         *        The name of the template that you want to disassociate from one or more repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateName(String approvalRuleTemplateName);

        /**
         * <p>
         * The repository names that you want to disassociate from the approval rule template.
         * </p>
         * <note>
         * <p>
         * The length constraint limit is for each string in the array. The array itself can be empty.
         * </p>
         * </note>
         * 
         * @param repositoryNames
         *        The repository names that you want to disassociate from the approval rule template.</p> <note>
         *        <p>
         *        The length constraint limit is for each string in the array. The array itself can be empty.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(Collection<String> repositoryNames);

        /**
         * <p>
         * The repository names that you want to disassociate from the approval rule template.
         * </p>
         * <note>
         * <p>
         * The length constraint limit is for each string in the array. The array itself can be empty.
         * </p>
         * </note>
         * 
         * @param repositoryNames
         *        The repository names that you want to disassociate from the approval rule template.</p> <note>
         *        <p>
         *        The length constraint limit is for each string in the array. The array itself can be empty.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(String... repositoryNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String approvalRuleTemplateName;

        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest model) {
            super(model);
            approvalRuleTemplateName(model.approvalRuleTemplateName);
            repositoryNames(model.repositoryNames);
        }

        public final String getApprovalRuleTemplateName() {
            return approvalRuleTemplateName;
        }

        @Override
        public final Builder approvalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
            return this;
        }

        public final void setApprovalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
        }

        public final Collection<String> getRepositoryNames() {
            return repositoryNames;
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String... repositoryNames) {
            repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest build() {
            return new BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
