/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterKey {
    HAS_ACCESS_TO("hasAccessTo"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterKey> VALUE_MAP;
    private final String value;

    private FilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterKey> knownValues() {
        EnumSet<FilterKey> knownValues = EnumSet.allOf(FilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterKey.class, FilterKey::toString);
    }
}

