/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ServerType {
    GITHUB("GITHUB"),
    BITBUCKET("BITBUCKET"),
    GITHUB_ENTERPRISE("GITHUB_ENTERPRISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ServerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ServerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerType> knownValues() {
        return Stream.of(ServerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

