/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.ReportExportConfigType;
import software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportExportConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportExportConfig> {
    private static final SdkField<String> EXPORT_CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportConfigType").getter(ReportExportConfig.getter(ReportExportConfig::exportConfigTypeAsString)).setter(ReportExportConfig.setter(Builder::exportConfigType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfigType").build()}).build();
    private static final SdkField<S3ReportExportConfig> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Destination").getter(ReportExportConfig.getter(ReportExportConfig::s3Destination)).setter(ReportExportConfig.setter(Builder::s3Destination)).constructor(S3ReportExportConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_CONFIG_TYPE_FIELD, S3_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportExportConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String exportConfigType;
    private final S3ReportExportConfig s3Destination;

    private ReportExportConfig(BuilderImpl builder) {
        this.exportConfigType = builder.exportConfigType;
        this.s3Destination = builder.s3Destination;
    }

    public final ReportExportConfigType exportConfigType() {
        return ReportExportConfigType.fromValue(this.exportConfigType);
    }

    public final String exportConfigTypeAsString() {
        return this.exportConfigType;
    }

    public final S3ReportExportConfig s3Destination() {
        return this.s3Destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportConfigTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportExportConfig)) {
            return false;
        }
        ReportExportConfig other = (ReportExportConfig)obj;
        return Objects.equals(this.exportConfigTypeAsString(), other.exportConfigTypeAsString()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public final String toString() {
        return ToString.builder((String)"ReportExportConfig").add("ExportConfigType", (Object)this.exportConfigTypeAsString()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportConfigType": {
                return Optional.ofNullable(clazz.cast(this.exportConfigTypeAsString()));
            }
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exportConfigType", EXPORT_CONFIG_TYPE_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportExportConfig, T> g) {
        return obj -> g.apply((ReportExportConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportConfigType;
        private S3ReportExportConfig s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportExportConfig model) {
            this.exportConfigType(model.exportConfigType);
            this.s3Destination(model.s3Destination);
        }

        public final String getExportConfigType() {
            return this.exportConfigType;
        }

        public final void setExportConfigType(String exportConfigType) {
            this.exportConfigType = exportConfigType;
        }

        @Override
        public final Builder exportConfigType(String exportConfigType) {
            this.exportConfigType = exportConfigType;
            return this;
        }

        @Override
        public final Builder exportConfigType(ReportExportConfigType exportConfigType) {
            this.exportConfigType(exportConfigType == null ? null : exportConfigType.toString());
            return this;
        }

        public final S3ReportExportConfig.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3ReportExportConfig.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(S3ReportExportConfig s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public ReportExportConfig build() {
            return new ReportExportConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportExportConfig> {
        public Builder exportConfigType(String var1);

        public Builder exportConfigType(ReportExportConfigType var1);

        public Builder s3Destination(S3ReportExportConfig var1);

        default public Builder s3Destination(Consumer<S3ReportExportConfig.Builder> s3Destination) {
            return this.s3Destination((S3ReportExportConfig)((S3ReportExportConfig.Builder)S3ReportExportConfig.builder().applyMutation(s3Destination)).build());
        }
    }
}

