/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.services.codebuild.model.NetworkInterface;
import software.amazon.awssdk.services.codebuild.model.SandboxSessionPhase;
import software.amazon.awssdk.services.codebuild.model.SandboxSessionPhasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SandboxSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SandboxSession> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SandboxSession.getter(SandboxSession::id)).setter(SandboxSession.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SandboxSession.getter(SandboxSession::status)).setter(SandboxSession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(SandboxSession.getter(SandboxSession::startTime)).setter(SandboxSession.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(SandboxSession.getter(SandboxSession::endTime)).setter(SandboxSession.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> CURRENT_PHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPhase").getter(SandboxSession.getter(SandboxSession::currentPhase)).setter(SandboxSession.setter(Builder::currentPhase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPhase").build()}).build();
    private static final SdkField<List<SandboxSessionPhase>> PHASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("phases").getter(SandboxSession.getter(SandboxSession::phases)).setter(SandboxSession.setter(Builder::phases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SandboxSessionPhase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLVED_SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolvedSourceVersion").getter(SandboxSession.getter(SandboxSession::resolvedSourceVersion)).setter(SandboxSession.setter(Builder::resolvedSourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedSourceVersion").build()}).build();
    private static final SdkField<LogsLocation> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logs").getter(SandboxSession.getter(SandboxSession::logs)).setter(SandboxSession.setter(Builder::logs)).constructor(LogsLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<NetworkInterface> NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkInterface").getter(SandboxSession.getter(SandboxSession::networkInterface)).setter(SandboxSession.setter(Builder::networkInterface)).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterface").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, CURRENT_PHASE_FIELD, PHASES_FIELD, RESOLVED_SOURCE_VERSION_FIELD, LOGS_FIELD, NETWORK_INTERFACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SandboxSession.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final String currentPhase;
    private final List<SandboxSessionPhase> phases;
    private final String resolvedSourceVersion;
    private final LogsLocation logs;
    private final NetworkInterface networkInterface;

    private SandboxSession(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.phases = builder.phases;
        this.resolvedSourceVersion = builder.resolvedSourceVersion;
        this.logs = builder.logs;
        this.networkInterface = builder.networkInterface;
    }

    public final String id() {
        return this.id;
    }

    public final String status() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String currentPhase() {
        return this.currentPhase;
    }

    public final boolean hasPhases() {
        return this.phases != null && !(this.phases instanceof SdkAutoConstructList);
    }

    public final List<SandboxSessionPhase> phases() {
        return this.phases;
    }

    public final String resolvedSourceVersion() {
        return this.resolvedSourceVersion;
    }

    public final LogsLocation logs() {
        return this.logs;
    }

    public final NetworkInterface networkInterface() {
        return this.networkInterface;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPhase());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhases() ? this.phases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedSourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterface());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SandboxSession)) {
            return false;
        }
        SandboxSession other = (SandboxSession)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.currentPhase(), other.currentPhase()) && this.hasPhases() == other.hasPhases() && Objects.equals(this.phases(), other.phases()) && Objects.equals(this.resolvedSourceVersion(), other.resolvedSourceVersion()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.networkInterface(), other.networkInterface());
    }

    public final String toString() {
        return ToString.builder((String)"SandboxSession").add("Id", (Object)this.id()).add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CurrentPhase", (Object)this.currentPhase()).add("Phases", this.hasPhases() ? this.phases() : null).add("ResolvedSourceVersion", (Object)this.resolvedSourceVersion()).add("Logs", (Object)this.logs()).add("NetworkInterface", (Object)this.networkInterface()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "currentPhase": {
                return Optional.ofNullable(clazz.cast(this.currentPhase()));
            }
            case "phases": {
                return Optional.ofNullable(clazz.cast(this.phases()));
            }
            case "resolvedSourceVersion": {
                return Optional.ofNullable(clazz.cast(this.resolvedSourceVersion()));
            }
            case "logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "networkInterface": {
                return Optional.ofNullable(clazz.cast(this.networkInterface()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("currentPhase", CURRENT_PHASE_FIELD);
        map.put("phases", PHASES_FIELD);
        map.put("resolvedSourceVersion", RESOLVED_SOURCE_VERSION_FIELD);
        map.put("logs", LOGS_FIELD);
        map.put("networkInterface", NETWORK_INTERFACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SandboxSession, T> g) {
        return obj -> g.apply((SandboxSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private String currentPhase;
        private List<SandboxSessionPhase> phases = DefaultSdkAutoConstructList.getInstance();
        private String resolvedSourceVersion;
        private LogsLocation logs;
        private NetworkInterface networkInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(SandboxSession model) {
            this.id(model.id);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.currentPhase(model.currentPhase);
            this.phases(model.phases);
            this.resolvedSourceVersion(model.resolvedSourceVersion);
            this.logs(model.logs);
            this.networkInterface(model.networkInterface);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getCurrentPhase() {
            return this.currentPhase;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final List<SandboxSessionPhase.Builder> getPhases() {
            List<SandboxSessionPhase.Builder> result = SandboxSessionPhasesCopier.copyToBuilder(this.phases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhases(Collection<SandboxSessionPhase.BuilderImpl> phases) {
            this.phases = SandboxSessionPhasesCopier.copyFromBuilder(phases);
        }

        @Override
        public final Builder phases(Collection<SandboxSessionPhase> phases) {
            this.phases = SandboxSessionPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(SandboxSessionPhase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<SandboxSessionPhase.Builder> ... phases) {
            this.phases(Stream.of(phases).map(c -> (SandboxSessionPhase)((SandboxSessionPhase.Builder)SandboxSessionPhase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResolvedSourceVersion() {
            return this.resolvedSourceVersion;
        }

        public final void setResolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
        }

        @Override
        public final Builder resolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
            return this;
        }

        public final LogsLocation.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return this.networkInterface != null ? this.networkInterface.toBuilder() : null;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public SandboxSession build() {
            return new SandboxSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SandboxSession> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder currentPhase(String var1);

        public Builder phases(Collection<SandboxSessionPhase> var1);

        public Builder phases(SandboxSessionPhase ... var1);

        public Builder phases(Consumer<SandboxSessionPhase.Builder> ... var1);

        public Builder resolvedSourceVersion(String var1);

        public Builder logs(LogsLocation var1);

        default public Builder logs(Consumer<LogsLocation.Builder> logs) {
            return this.logs((LogsLocation)((LogsLocation.Builder)LogsLocation.builder().applyMutation(logs)).build());
        }

        public Builder networkInterface(NetworkInterface var1);

        default public Builder networkInterface(Consumer<NetworkInterface.Builder> networkInterface) {
            return this.networkInterface((NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation(networkInterface)).build());
        }
    }
}

